/**
    \file config.h
    \author Assad Ali
    \brief Configuration file for Distance2Go project.
*/

/* ===========================================================================
** Copyright (C) 2017 Infineon Technologies AG
** All rights reserved.
** ===========================================================================
**
** ===========================================================================
** This document contains proprietary information of Infineon Technologies AG.
** Passing on and copying of this document, and communication of its contents
** is not permitted without Infineon's prior written authorization.
** ===========================================================================
*/

#ifndef CONFIG_GAURD_H
#define CONFIG_GAURD_H

/*
==============================================================================
   1. DEFINITIONS
==============================================================================
*/

//================================ GENERAL CONFIG ================================//

#define FW_MODULATION_TYPE 		(1U)		/**< FW Modulation Type ==>  0: Doppler;  1: FMCW  [0 - 1] */

#define	NUM_OF_CHIRPS			(1U)		/**< Valid range of chirps in relation to the DATA_SIZE ==> [1 - 16] */

#define	DATA_SIZE 			(64U)		/**< Size of IQ raw ADC buffer ==> [16 - 250] */

#define	FFT_SIZE 			(1024U)		/**< FFT length for FMCW mode, zero padding supported [DATA_SIZE - 1024] */

#define FFT_WINDOW			(0U) 		/**< FFT Windows: Default = Blackman; Kaiser = 1, High Accuracy = 2 */

#define	FFT_INPUT_TYPE			(2U)        /**< FFT input: Default = complex input IQ; real input I = 0, real input Q = 1 */

#define	MVG_AVG_LEN			(0U)		/**< Moving average window length N => [1 - 8] */

#define	NUM_OF_TARGETS			(16U)		/**< Maximum number of targets to be detected, [1 - 16] */

#define FRAME_PERIOD_ms 		(400U)    	/**< Time period of one frame to capture data [50 - Infinity] */


//================================ BGT CONFIG ====================================//

#define BGT_DUTY_CYCLE 						/**< Comment or uncomment for duty cycling of Distance2Go via BGT & PLL On/Off  */

#define BGT_TX_POWER			(7U)		/**< BGT TX Power levels [1 - 7], Minimum = 1 & Maximum = 7 */

#define LNA_GAIN_ENABLE			(1U)		/**< Enable and disable LNA Gain in BGT TX [0 - 1] */

//================================ FMCW CONFIG ====================================//

#define	FMCW_SUPPORTED						/**<  un-comment this macro, to disable FMCW support from algorithm API */

#define BANDWIDTH_MHz 			(180U)    	/**< Bandwidth in MHz (0 - 250MHz) */

#define CHIRP_TIME_us 			(900U)    	/**< Chirp time in microseconds (50us - 3000us)  3.5us*256 */


#define INTER_CHIRP_TIME_us             (1000U)

#define MINIMUM_DISTANCE_cm 	(60U)    	/**< Used in FMCW to exclude targets below this distance (units in cm) */

#define MAXIMUM_DISTANCE_cm 	(5000U)    	/**< Used in FMCW to exclude targets beyond this distance (units in cm) */

#define FMCW_DETECTION_THRESHOLD (0U)   	/**< FFT spectrum threshold to detect a target in FMCW */

#define FMCW_SAMPLING_FREQ_Hz  ((float)DATA_SIZE / (float)CHIRP_TIME_us * 1000.0f * 1000.0f) 	/**< Sampling frequency in Hz for FMCW */

//================================ DOPPLER CONFIG ====================================//

#define DOPPLER_SAMPLING_FREQ_Hz (20000U) 	/**< Sampling frequency in Hz for Doppler */

#define	DOPPLER_DATA_SIZE		 (250U)		/**< Sampling buffer size for Doppler */

#define MINIMUM_SPEED_kmh 		(0U)    	/**< Used in Doppler to exclude targets below this speed (units in kmh) */

#define MAXIMUM_SPEED_kmh 		(200U)    	/**< Used in FMCW to exclude targets above this speed (units in kmh) */

#define DOPPLER_DETECTION_THRESHOLD (50U)   /**< FFT spectrum threshold to detect a target in Doppler */

#endif

#define true 1
#define false 0


/* --- End of File ------------------------------------------------ */

