/**************************************************************************************************/
/* Hardware Specific constants                                                                    */
/**************************************************************************************************/
#include "typedefine.h"

#define CAN_ENABLE						0

#define FMCW_BASE_FREQ_MHz	 			(24060U) 		/*!< Base frequency for FMCW */

#define DOPPLER_BASE_FREQ_MHz			(24125U) 		/*!< Base frequency for Doppler */

#define D2GO_MIN_FREQUENCY_kHz          24060000U  		/*!< Minimum RF frequency supported by BGT24MTR11 in kHz */

#define D2GO_MAX_FREQUENCY_kHz          24240000U  		/*!< Maximum RF frequency supported by BGT24MTR11 in kHz */

#define REFERENCE_OSC_FREQ_Hz           40000000U  		/*!< Reference Oscillator frequency for PLL */

#define MAX_ADC_DATA_BUFFER_SIZE       	8192U         	/*!< Maximum size of buffer to hold the raw ADC samples */

#define MAX_NUM_CHIRPS_PER_FRAME      	2048U      		/*!< Maximum supports up to 16 ramps, but a single cycle uses up to 2 ramp sections. */

#define MAX_NUM_SAMPLES_PER_CHIRP       250U      		/*!< Maximum Samples per chirp supported */

#define MAX_TX_POWER_LEVEL             	7U         		/*!< Maximum BGT TX output power SPI input value range is [1 - 7] supported by BGT24MTR12. */

#define NUM_TX_ANTENNAS                	1U         		/*!< There is single TX antenna in BGT24MTR11. */

#define NUM_RX_ANTENNAS                	1U         		/*!< There is single RX antenna in BGT24MTR11. */

#define RX_ANTENNA_MASK               	0x01U         	/*!< There is single Rx Antenna to be selected*/

#define NUM_TEMP_SENSORS               	1U         		/*!< There is single Temperature sensor in BGT24MTR11. */

#define ADC_RESOLUTION               	12U         	/*!< Number of bits per ADC data sample */

#define MAX_ADC_FREQ_Hz               	1700000U       	/*!< Maximum sampling frequency of the XMC ADC */

//================================ GENERAL CONFIG ================================//

#define FW_MODULATION_TYPE 		(1U)		/**< FW Modulation Type ==>  0: Doppler;  1: FMCW  [0 - 1] */

#define	NUM_OF_CHIRPS			(1U)		/**< Valid range of chirps in relation to the DATA_SIZE ==> [1 - 16] */

#define FFT_WINDOW			(0U) 		/**< FFT Windows: Default = Blackman; Kaiser = 1, High Accuracy = 2 */

#define	FFT_INPUT_TYPE			(2U)        /**< FFT input: Default = complex input IQ; real input I = 0, real input Q = 1 */

#define	MVG_AVG_LEN			(0U)		/**< Moving average window length N => [1 - 8] */

#define	NUM_OF_TARGETS			(16U)		/**< Maximum number of targets to be detected, [1 - 16] */

#define FRAME_PERIOD_ms 		(400U)    	/**< Time period of one frame to capture data [50 - Infinity] */

#define F_ANT1DATAEND		1
#define F_ANT2DATAEND		2
#define F_SWEEPEND			3

// --------------------------------------------------------------------
extern volatile  uint32_t   g_num_of_chirps;
extern volatile uint8_t	   g_update_pll_configurations;
extern volatile int8_t r_sweepend;
extern unsigned char svrsetdata[256];
extern char tx_power;
extern short phaseOffset;
extern int peakHoldTm;
extern uint8_t status;
extern volatile uint8_t IS_CW;

void radarInit();
void time_delay_usec(int num);
void delay_250us(void);
void SendUartByte(char dat);
void Serial_Send(uint8_t * const tx_buf, uint16_t tx_num);
uint8_t FT245_INDATA(void);

#define		MODE_INIT		9
#define		MODE_SWR		10
#define		MODE_MIX		11
#define		MODE_MIT		12
#define		MODE_DPR		13
#define		MODE_FSK		14
#define		MODE_FMCW1		15
#define		MODE_FSK1		16
#define		MODE_FSKSLESS	17
#define		MODE_DPRSLESS	18


extern uint8_t status;

void bgt_pll_power_up(void);
