#include "typedefine.h"
#include "Config_PORT.h"
#include "iodefine.h"
#include "common.h"
#include "LMX249x.h"
#include "radar.h"

void spi_transmit_data_pll(const uint8_t* data_ptr, uint8_t num_of_bytes)
{
	uint8_t i;

	PLL_CS=0;

//	_nop(); _nop(); _nop(); _nop();
	time_delay_usec(10);

	for (uint8_t count = 0U; count < num_of_bytes; count++)
	{
		uint8_t data = *data_ptr++;

		for (i=0; i < 8U; i++)
		{
			if (data & 0x80)
			{
				PLL_DAT=1;
			}
			else
			{
				PLL_DAT=0;
			}

//			_nop(); _nop();
			time_delay_usec(10);

			PLL_CLK=1;

//			_nop(); _nop(); _nop(); _nop();
			time_delay_usec(10);

			PLL_CLK=0;

//			_nop(); _nop();
			time_delay_usec(10);

			data <<= 1;
		}
	}

	PLL_CS=1;


//	_nop(); _nop(); _nop(); _nop();
	time_delay_usec(10);
}

void spi_transmit_data_bgt(const uint8_t* data_ptr, uint8_t num_of_bytes)
{
	uint8_t i;

	BGT_CS=0;

//	_nop(); _nop(); _nop(); _nop();
	time_delay_usec(10);

	for (uint8_t count = 0U; count < num_of_bytes; count++)
	{
		uint8_t data = *data_ptr++;

		for (i=0; i < 8U; i++)
		{
			if (data & 0x80)
			{
				PLL_DAT=1;
			}
			else
			{
				PLL_DAT=0;
			}

//			_nop(); _nop();
			time_delay_usec(10);

			PLL_CLK=1;

//			_nop(); _nop(); _nop(); _nop();
			time_delay_usec(10);

			PLL_CLK=0;

//			_nop(); _nop();
			time_delay_usec(10);

			data <<= 1;
		}
	}

	BGT_CS=1;


//	_nop(); _nop(); _nop(); _nop();
	time_delay_usec(10);
}