#include "r_cg_macrodriver.h"
#include "Config_PORT.h"
#include "Config_TMR0_TMR1.h"
#include "Config_S12AD0.h"

#include "iodefine.h"
#include "stdio.h"
#include "math.h"
#include "stdlib.h"
#include "string.h"
#include "mathf.h"
#include "config.h"
#include "common.h"
#include "LMX249x.h"
#include "pll.h"
#include "radar.h"
#include "typedefine.h"

#define M_PI 3.14159265358979323846


volatile uint8_t IS_CW=1;

volatile  uint32_t   g_num_of_chirps = NUM_OF_CHIRPS;
volatile  uint8_t    g_update_pll_configurations = false;
volatile int8_t r_sweepend;
uint8_t status=MODE_SWR;



char SETMODEL[]={"RFR24B-12 DPR"};
char SETVER[]={"v4.00.00"};				// sweep 1ms .02

unsigned char svrsetdata[256];

unsigned char read_buffer[80];

unsigned char reqRadarProc=0;
char tx_power=0;
uint8_t tbuf[5];

void SetIFGain(uint8_t gn);
void setDma0DistAdr(void * dest_addr);

void startDoppler();


void time_delay_usec(int num)
{
	volatile int i;
	for( i=0; i<num; i++) ;	// 89 @ 10MHz
}

void delay_us(int num)
{
	volatile int i;
	for( i=0; i<num; i++) ;	// 89 @ 10MHz
}


void delay_250us(void)
{
	volatile int i;
	for( i=0; i<3000; i++) ;	// 89 @ 10MHz
}

void delay_ms(int t)
{
	int i;
	
	for (i=0;i<t;i++){
		delay_250us();
		delay_250us();
		delay_250us();
		delay_250us();
	}
}


void FT245_SETDATA(uint8_t dat)
{
	if (dat&0x80) FT245_BIT7=1;
	else FT245_BIT7=0;
	
	if (dat&0x40) FT245_BIT6=1;
	else FT245_BIT6=0;
	
	if (dat&0x20) FT245_BIT5=1;
	else FT245_BIT5=0;
	
	if (dat&0x10) FT245_BIT4=1;
	else FT245_BIT4=0;	
	
	if (dat&0x08) FT245_BIT3=1;
	else FT245_BIT3=0;
	
	if (dat&0x04) FT245_BIT2=1;
	else FT245_BIT2=0;
	
	if (dat&0x02) FT245_BIT1=1;
	else FT245_BIT1=0;
	
	if (dat&0x01) FT245_BIT0=1;
	else FT245_BIT0=0;
}


uint8_t FT245_INDATA(void)
{
	uint8_t dat=0;
	
	
	FT245_PDR_BIT7=0;
	FT245_PDR_BIT6=0;
	FT245_PDR_BIT5=0;
	FT245_PDR_BIT4=0;
	FT245_PDR_BIT3=0;
	FT245_PDR_BIT2=0;
	FT245_PDR_BIT1=0;
	FT245_PDR_BIT0=0;
	
	FT245_RD=0;
	time_delay_usec(10);		// xxus  delay for PLL Lock
	
//	DEBUG_OUT^=1;
	if (FT245_IN_BIT7) dat|=0x80;
	if (FT245_IN_BIT6) dat|=0x40;
	if (FT245_IN_BIT5) dat|=0x20;
	if (FT245_IN_BIT4) dat|=0x10;
	if (FT245_IN_BIT3) dat|=0x08;
	if (FT245_IN_BIT2) dat|=0x04;
	if (FT245_IN_BIT1) dat|=0x02;
	if (FT245_IN_BIT0) dat|=0x01;
	
	FT245_RD=1;
	
	FT245_PDR_BIT7=1;
	FT245_PDR_BIT6=1;
	FT245_PDR_BIT5=1;
	FT245_PDR_BIT4=1;
	FT245_PDR_BIT3=1;
	FT245_PDR_BIT2=1;
	FT245_PDR_BIT1=1;
	FT245_PDR_BIT0=1;
	
	return dat;
}

void out_2byte_usb (short ddd)
{
	
   union iudata
   {
       short word[1];
       char byte[2];
   } uarea_i;
   

    uarea_i.word[0]=ddd;                //16bit̃f[^dddL

	while (FT245_TXE==1) ;
	FT245_SETDATA(uarea_i.byte[1]);
	FT245_WR=0;
	FT245_WR=1;
	while (FT245_TXE==1) ;
	FT245_SETDATA(uarea_i.byte[0]);
	FT245_WR=0;
	FT245_WR=1;			
}

void out_1byte_usb (unsigned char ddd)
{
	while (FT245_TXE==1) ;
	FT245_SETDATA(ddd);
	FT245_WR=0;
	FT245_WR=1;
}

void Serial_Send(uint8_t * const tx_buf, uint16_t tx_num)
{
	unsigned char i;
	
	for(i=0; i<tx_num; i++){
		while (FT245_TXE==1) ;
		FT245_SETDATA(tx_buf[i]);
		FT245_WR=0;
		FT245_WR=1;
	}
}

void DebugLog(char * msg)
{
	unsigned char i=0;
	
	while(msg[i]!=0x00){
		while (FT245_TXE==1) ;
		FT245_SETDATA(msg[i]);
		FT245_WR=0;
		FT245_WR=1;
		i++;
	}
}

int USBstreamRcv(unsigned char *buf,int len)
{
	int i=0,timeout=0;
	unsigned char rcv;

	while(timeout<1000){
	    if (FT245_RXE==0){
			rcv=FT245_INDATA();
			buf[i]=rcv;
		
			i++;
			if (i==len) return 1;
		}else{
			delay_ms(1);	
		}
		timeout++;
	}
	return 0;
}

void SendUartByte(char dat)
{
	int timeout=0;
	
	while (FT245_TXE==1){
		if (timeout++>10000) return;
		delay_us(1);
	}
	FT245_SETDATA(dat);
	FT245_WR=0;
	FT245_WR=1;
}


void radarInit()
{
	
	RF_POWER_ON=1;
	delay_ms(200);

	bgt_init();

	bgt_power_up();

	time_delay_usec(100U);					// delay for BGT Power up

	pll_enable();

	time_delay_usec(100U);					// delay for PLL Power up

	pll_init(pll_handle);

	time_delay_usec(100U);

	pll_update_configuration();
	
	SetIFGain(1);

	SEL_FMCW=SW_FSK;			// cw
	
}

void startDoppler()
{
	 status=MODE_DPR;

	SEL_FMCW=SW_FSK;
	
	bgt_pll_power_up();

	if (g_update_pll_configurations == true)
	{
		pll_update_configuration();

		g_update_pll_configurations = false;
	}

	bgt_start_tx();

	R_Config_S12AD0_Stop();
	R_Config_DMAC0_Stop();
	R_Config_MTU2_Stop();
	
	R_Config_S12AD0_Create_dpr();
	R_Config_S12AD0_Start();
	R_Config_MTU0_Start();	
}

int32_t get_raw_data(void)
{
}
	

void bgt_pll_power_up(void)
{
	bgt_power_up();

	time_delay_usec(50U);					// 	50us delay for BGT Power up

	pll_enable();

	if (g_update_pll_configurations == true)
	{
		pll_update_configuration();

		g_update_pll_configurations = false;
	}
	else
	{
		pll_enable_ramps(pll_handle);
	}

	time_delay_usec(50);		// xxus  delay for PLL Lock

	bgt_start_tx();

//	time_delay_usec(2000);   // xxxus delay for BGT Q2 divider to be zero and VCO to be settled after SPI setting transmitted
	delay_ms(2);
}

void SetIFGain(uint8_t gn)
{

	if((gn&0x01) !=0){
		SEL_GAIN_0=1;
	}else{
		SEL_GAIN_0=0;
	}		
}

int filenum;
uint8_t *filepos;
int iii;


void commandCheck(void)
{
    uint8_t rcv;
    uint16_t i,n;
    char st[1024],stb[32];
	int t;
	float fwk;
    
	
    // R}h҂
    if (FT245_RXE==0){
		rcv=FT245_INDATA();
		
		if (rcv=='c'){	// cR}h
			SendUartByte('P');
			status=MODE_INIT;

		}else if(rcv=='O'){
			while(1){
				if (FT245_RXE==0){
					rcv=FT245_INDATA();
					if ((rcv>='0') && (rcv<='7')){
						SetIFGain(rcv-'0');
						SendUartByte('O');
					}
					break;
				}
			}	
		}else if(rcv=='R'){
			if( status!=MODE_DPR){
				startDoppler();
			}

		}else if(rcv=='V'){
			sprintf(st,"%s",SETMODEL);
			strcat(st,",");
			strcat(st,SETVER);
			n = strlen(st);
			if(n>26){
				i=0;
			}else{
				for(i=n; i<26; i++){
					st[i]=' ';
				}
			}
			st[26]='\0';
			strcat(st,",I12");
			DebugLog(st);			
		}else if(rcv=='~'){
			if(USBstreamRcv(read_buffer,1)==1){
			}

		}else if (rcv=='Y'){
			IS_CW=1;
		}
	}
}

void 	adReadEnd()
{
	union iudata
	{
	    unsigned short word[1];
	    char byte[2];
	} uarea_i;
   
	if(status!=MODE_DPR) return;
	
	uint16_t IFDAT;
	R_Config_S12AD0_Get_ValueResult(ADCHANNEL0, &uarea_i.word[0]);
	
	uarea_i.word[0] *= 0x10;
	tbuf[0] = uarea_i.byte[1];
	tbuf[1] = uarea_i.byte[0];
	R_Config_S12AD0_Get_ValueResult(ADCHANNEL1, &uarea_i.word[0]);
	uarea_i.word[0] *= 0x10;
	tbuf[2] = uarea_i.byte[1];
	tbuf[3] = uarea_i.byte[0];
	tbuf[4] = 0;
	Serial_Send(tbuf,5);	
	
}