/***********************************************************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products. No
* other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
* applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM
* EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES
* SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO THIS
* SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of
* this software. By using this software, you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2016-2019 Renesas Electronics Corporation. All rights reserved.
***********************************************************************************************************************/
/***********************************************************************************************************************
* File Name    : r_flash_rx65n.h
* Description  : This is a private header file used internally by the FLASH API module. It should not be modified or
* 				 included by the user in their application.
***********************************************************************************************************************/
/***********************************************************************************************************************
* History : DD.MM.YYYY Version Description
*         : 03.02.2016 1.00    First Release
*         : 14.07.2016 2.00    Modified for BSPless flash.
*         : 24.01.2017 2.10    Added 1.5M, 2M and data flash equates.
*         : 19.06.2017 2.20    Added FLASH_HAS_APP_SWAP qualification to bank mode check.
*         : 02.08.2017 2.30    Replaced #include "r_mcu_config.h" with "r_flash_targets.h"
*         : 19.04.2019 4.00    Added support for GNUC and ICCRX.
*         : 19.07.2019 4.20    Deleted FLASH_RAM_END_ADDRESS, NUM_BLOCK_TABLE_ENTRIES,
*                              g_flash_RomBlockSizes, rom_block_sizes_t, rom_block_info_t.
*                              Added FLASH_CF_LO_BANK_SMALL_BLOCK_ADDR.
***********************************************************************************************************************/

#ifndef RX65N_FLASH_PRIVATE_HEADER_FILE
#define RX65N_FLASH_PRIVATE_HEADER_FILE

#include "r_flash_targets.h"

/***********************************************************************************************************************
Macro definitions
***********************************************************************************************************************/

#if (MCU_CFG_PART_MEMORY_SIZE == 0x4)       // 512 Kb
     #define FLASH_NUM_BLOCKS_CF (14+8)
#elif (MCU_CFG_PART_MEMORY_SIZE == 0x7 )    // 768 Kb
     #define FLASH_NUM_BLOCKS_CF (22+8)
#elif (MCU_CFG_PART_MEMORY_SIZE == 0x9 )    // 1 Mb
     #define FLASH_NUM_BLOCKS_CF (30+8)
#elif (MCU_CFG_PART_MEMORY_SIZE == 0xC)
    #if FLASH_IN_DUAL_BANK_MODE
        #define FLASH_NUM_BLOCKS_CF (22+8)  // .75 Mb per bank dual mode
    #else
        #define FLASH_NUM_BLOCKS_CF (46+8)  // 1.5 Mb linear mode
    #endif
#elif (MCU_CFG_PART_MEMORY_SIZE == 0xE)
    #if FLASH_IN_DUAL_BANK_MODE
        #define FLASH_NUM_BLOCKS_CF (30+8)  // 1 Mb per bank dual mode
    #else
        #define FLASH_NUM_BLOCKS_CF (62+8)  // 2 Mb linear mode
    #endif
#endif


#define FLASH_NUM_BLOCKS_DF                 (512)
#define FLASH_DF_MIN_PGM_SIZE               (4)
#define FLASH_CF_MIN_PGM_SIZE               (128)

#define FLASH_CF_SMALL_BLOCK_SIZE           (8192)
#define FLASH_CF_MEDIUM_BLOCK_SIZE          (32768)
#define FLASH_CF_LO_BANK_SMALL_BLOCK_ADDR   (FLASH_CF_BLOCK_45)
#define FLASH_CF_LOWEST_VALID_BLOCK         (FLASH_CF_BLOCK_INVALID + 1)
#define FLASH_DF_BLOCK_SIZE                 (64)
#define FLASH_DF_HIGHEST_VALID_BLOCK        (FLASH_DF_BLOCK_INVALID - FLASH_DF_BLOCK_SIZE)

/***********************************************************************************************************************
Typedef definitions
***********************************************************************************************************************/
typedef enum _flash_block_address
{
#ifndef FLASH_IN_DUAL_BANK_MODE                                              /* LINEAR MODE */
    FLASH_CF_BLOCK_END     = 0xFFFFFFFF,    /*   End of Code Flash Area       */
    FLASH_CF_BLOCK_0       = 0xFFFFE000,    /*   8KB: 0xFFFFE000 - 0xFFFFFFFF */
    FLASH_CF_BLOCK_1       = 0xFFFFC000,    /*   8KB: 0xFFFFC000 - 0xFFFFDFFF */
    FLASH_CF_BLOCK_2       = 0xFFFFA000,    /*   8KB: 0xFFFFA000 - 0xFFFFBFFF */
    FLASH_CF_BLOCK_3       = 0xFFFF8000,    /*   8KB: 0xFFFF8000 - 0xFFFF9FFF */
    FLASH_CF_BLOCK_4       = 0xFFFF6000,    /*   8KB: 0xFFFF6000 - 0xFFFF7FFF */
    FLASH_CF_BLOCK_5       = 0xFFFF4000,    /*   8KB: 0xFFFF4000 - 0xFFFF5FFF */
    FLASH_CF_BLOCK_6       = 0xFFFF2000,    /*   8KB: 0xFFFF2000 - 0xFFFF3FFF */
    FLASH_CF_BLOCK_7       = 0xFFFF0000,    /*   8KB: 0xFFFF0000 - 0xFFFF1FFF */
    FLASH_CF_BLOCK_8       = 0xFFFE8000,    /*  32KB: 0xFFFE8000 - 0xFFFEFFFF */
    FLASH_CF_BLOCK_9       = 0xFFFE0000,    /*  32KB: 0xFFFE0000 - 0xFFFE7FFF */
    FLASH_CF_BLOCK_10      = 0xFFFD8000,    /*  32KB: 0xFFFD8000 - 0xFFFDFFFF */
    FLASH_CF_BLOCK_11      = 0xFFFD0000,    /*  32KB: 0xFFFD0000 - 0xFFFD7FFF */
    FLASH_CF_BLOCK_12      = 0xFFFC8000,    /*  32KB: 0xFFFC8000 - 0xFFFCFFFF */
    FLASH_CF_BLOCK_13      = 0xFFFC0000,    /*  32KB: 0xFFFC0000 - 0xFFFC7FFF */
    FLASH_CF_BLOCK_14      = 0xFFFB8000,    /*  32KB: 0xFFFB8000 - 0xFFFBFFFF */
    FLASH_CF_BLOCK_15      = 0xFFFB0000,    /*  32KB: 0xFFFB0000 - 0xFFFB7FFF */
    FLASH_CF_BLOCK_16      = 0xFFFA8000,    /*  32KB: 0xFFFA8000 - 0xFFFAFFFF */
    FLASH_CF_BLOCK_17      = 0xFFFA0000,    /*  32KB: 0xFFFA0000 - 0xFFFA7FFF */
    FLASH_CF_BLOCK_18      = 0xFFF98000,    /*  32KB: 0xFFF98000 - 0xFFF9FFFF */
    FLASH_CF_BLOCK_19      = 0xFFF90000,    /*  32KB: 0xFFF90000 - 0xFFF97FFF */
    FLASH_CF_BLOCK_20      = 0xFFF88000,    /*  32KB: 0xFFF88000 - 0xFFF8FFFF */
    FLASH_CF_BLOCK_21      = 0xFFF80000,    /*  32KB: 0xFFF80000 - 0xFFF87FFF */
#if   MCU_CFG_PART_MEMORY_SIZE == 0x04  /*   '4' parts 512 Kb ROM */
    FLASH_CF_BLOCK_INVALID = (FLASH_CF_BLOCK_21 - 1),
#else
    FLASH_CF_BLOCK_22      = 0xFFF78000,    /*  32KB: 0xFFF78000 - 0xFFF7FFFF */
    FLASH_CF_BLOCK_23      = 0xFFF70000,    /*  32KB: 0xFFF70000 - 0xFFF77FFF */
    FLASH_CF_BLOCK_24      = 0xFFF68000,    /*  32KB: 0xFFF68000 - 0xFFF6FFFF */
    FLASH_CF_BLOCK_25      = 0xFFF60000,    /*  32KB: 0xFFF60000 - 0xFFF67FFF */
    FLASH_CF_BLOCK_26      = 0xFFF58000,    /*  32KB: 0xFFF58000 - 0xFFF5FFFF */
    FLASH_CF_BLOCK_27      = 0xFFF50000,    /*  32KB: 0xFFF50000 - 0xFFF57FFF */
    FLASH_CF_BLOCK_28      = 0xFFF48000,    /*  32KB: 0xFFF48000 - 0xFFF4FFFF */
    FLASH_CF_BLOCK_29      = 0xFFF40000,    /*  32KB: 0xFFF40000 - 0xFFF47FFF */
#if   MCU_CFG_PART_MEMORY_SIZE == 0x07  /*   '7' parts 768 Kb ROM */
    FLASH_CF_BLOCK_INVALID = (FLASH_CF_BLOCK_29 - 1),
#else
    FLASH_CF_BLOCK_30      = 0xFFF38000,    /*  32KB: 0xFFF38000 - 0xFFF3FFFF */
    FLASH_CF_BLOCK_31      = 0xFFF30000,    /*  32KB: 0xFFF30000 - 0xFFF37FFF */
    FLASH_CF_BLOCK_32      = 0xFFF28000,    /*  32KB: 0xFFF28000 - 0xFFF2FFFF */
    FLASH_CF_BLOCK_33      = 0xFFF20000,    /*  32KB: 0xFFF20000 - 0xFFF27FFF */
    FLASH_CF_BLOCK_34      = 0xFFF18000,    /*  32KB: 0xFFF18000 - 0xFFF1FFFF */
    FLASH_CF_BLOCK_35      = 0xFFF10000,    /*  32KB: 0xFFF10000 - 0xFFF17FFF */
    FLASH_CF_BLOCK_36      = 0xFFF08000,    /*  32KB: 0xFFF08000 - 0xFFF0FFFF */
    FLASH_CF_BLOCK_37      = 0xFFF00000,    /*  32KB: 0xFFF00000 - 0xFFF07FFF */
#if   MCU_CFG_PART_MEMORY_SIZE == 0x09  /*   '9' parts 1 Mb ROM */
    FLASH_CF_BLOCK_INVALID = (FLASH_CF_BLOCK_37 - 1),
#else
    FLASH_CF_BLOCK_38      = 0xFFEF8000,    /*  32KB: 0xFFEF8000 - 0xFFEFFFFF */
    FLASH_CF_BLOCK_39      = 0xFFEF0000,    /*  32KB: 0xFFEF0000 - 0xFFEF7FFF */
    FLASH_CF_BLOCK_40      = 0xFFEE8000,    /*  32KB: 0xFFEE8000 - 0xFFEEFFFF */
    FLASH_CF_BLOCK_41      = 0xFFEE0000,    /*  32KB: 0xFFEE0000 - 0xFFEE7FFF */
    FLASH_CF_BLOCK_42      = 0xFFED8000,    /*  32KB: 0xFFED8000 - 0xFFEDFFFF */
    FLASH_CF_BLOCK_43      = 0xFFED0000,    /*  32KB: 0xFFED0000 - 0xFFED7FFF */
    FLASH_CF_BLOCK_44      = 0xFFEC8000,    /*  32KB: 0xFFEC8000 - 0xFFECFFFF */
    FLASH_CF_BLOCK_45      = 0xFFEC0000,    /*  32KB: 0xFFEC0000 - 0xFFEC7FFF */
    FLASH_CF_BLOCK_46      = 0xFFEB8000,    /*  32KB: 0xFFEB8000 - 0xFFEBFFFF */
    FLASH_CF_BLOCK_47      = 0xFFEB0000,    /*  32KB: 0xFFEB0000 - 0xFFEB7FFF */
    FLASH_CF_BLOCK_48      = 0xFFEA8000,    /*  32KB: 0xFFEA8000 - 0xFFEAFFFF */
    FLASH_CF_BLOCK_49      = 0xFFEA0000,    /*  32KB: 0xFFEA0000 - 0xFFEA7FFF */
    FLASH_CF_BLOCK_50      = 0xFFE98000,    /*  32KB: 0xFFE98000 - 0xFFE9FFFF */
    FLASH_CF_BLOCK_51      = 0xFFE90000,    /*  32KB: 0xFFE90000 - 0xFFE97FFF */
    FLASH_CF_BLOCK_52      = 0xFFE88000,    /*  32KB: 0xFFE88000 - 0xFFE8FFFF */
    FLASH_CF_BLOCK_53      = 0xFFE80000,    /*  32KB: 0xFFE80000 - 0xFFE87FFF */
#if   MCU_CFG_PART_MEMORY_SIZE == 0x0C  /*   'C' parts 1.5 Mb ROM */
    FLASH_CF_BLOCK_INVALID = (FLASH_CF_BLOCK_53 - 1),
#else
    FLASH_CF_BLOCK_54      = 0xFFE78000,    /*  32KB: 0xFFE78000 - 0xFFE7FFFF */
    FLASH_CF_BLOCK_55      = 0xFFE70000,    /*  32KB: 0xFFE70000 - 0xFFE77FFF */
    FLASH_CF_BLOCK_56      = 0xFFE68000,    /*  32KB: 0xFFE68000 - 0xFFE6FFFF */
    FLASH_CF_BLOCK_57      = 0xFFE60000,    /*  32KB: 0xFFE60000 - 0xFFE67FFF */
    FLASH_CF_BLOCK_58      = 0xFFE58000,    /*  32KB: 0xFFE58000 - 0xFFE5FFFF */
    FLASH_CF_BLOCK_59      = 0xFFE50000,    /*  32KB: 0xFFE50000 - 0xFFE57FFF */
    FLASH_CF_BLOCK_60      = 0xFFE48000,    /*  32KB: 0xFFE48000 - 0xFFE4FFFF */
    FLASH_CF_BLOCK_61      = 0xFFE40000,    /*  32KB: 0xFFE40000 - 0xFFE47FFF */
    FLASH_CF_BLOCK_62      = 0xFFE38000,    /*  32KB: 0xFFE38000 - 0xFFE3FFFF */
    FLASH_CF_BLOCK_63      = 0xFFE30000,    /*  32KB: 0xFFE30000 - 0xFFE37FFF */
    FLASH_CF_BLOCK_64      = 0xFFE28000,    /*  32KB: 0xFFE28000 - 0xFFE2FFFF */
    FLASH_CF_BLOCK_65      = 0xFFE20000,    /*  32KB: 0xFFE20000 - 0xFFE27FFF */
    FLASH_CF_BLOCK_66      = 0xFFE18000,    /*  32KB: 0xFFE18000 - 0xFFE1FFFF */
    FLASH_CF_BLOCK_67      = 0xFFE10000,    /*  32KB: 0xFFE10000 - 0xFFE17FFF */
    FLASH_CF_BLOCK_68      = 0xFFE08000,    /*  32KB: 0xFFE08000 - 0xFFE0FFFF */
    FLASH_CF_BLOCK_69      = 0xFFE00000,    /*  32KB: 0xFFE00000 - 0xFFE07FFF */
    FLASH_CF_BLOCK_INVALID = (FLASH_CF_BLOCK_69 - 1), /* 'E' parts 2 Mb ROM */
#endif // > 1.5M
#endif // > 1M
#endif // > 768K
#endif // > 512K

#else                                       /* DUAL MODE */
    FLASH_CF_BLOCK_END     = 0xFFFFFFFF,    /*   End of Code Flash Area       */
    FLASH_CF_HI_BANK_HI_ADDR = FLASH_CF_BLOCK_END,
    FLASH_CF_BLOCK_0       = 0xFFFFE000,    /*   8KB: 0xFFFFE000 - 0xFFFFFFFF */
    FLASH_CF_BLOCK_1       = 0xFFFFC000,    /*   8KB: 0xFFFFC000 - 0xFFFFDFFF */
    FLASH_CF_BLOCK_2       = 0xFFFFA000,    /*   8KB: 0xFFFFA000 - 0xFFFFBFFF */
    FLASH_CF_BLOCK_3       = 0xFFFF8000,    /*   8KB: 0xFFFF8000 - 0xFFFF9FFF */
    FLASH_CF_BLOCK_4       = 0xFFFF6000,    /*   8KB: 0xFFFF6000 - 0xFFFF7FFF */
    FLASH_CF_BLOCK_5       = 0xFFFF4000,    /*   8KB: 0xFFFF4000 - 0xFFFF5FFF */
    FLASH_CF_BLOCK_6       = 0xFFFF2000,    /*   8KB: 0xFFFF2000 - 0xFFFF3FFF */
    FLASH_CF_BLOCK_7       = 0xFFFF0000,    /*   8KB: 0xFFFF0000 - 0xFFFF1FFF */
    FLASH_CF_BLOCK_8       = 0xFFFE8000,    /*  32KB: 0xFFFE8000 - 0xFFFEFFFF */
    FLASH_CF_BLOCK_9       = 0xFFFE0000,    /*  32KB: 0xFFFE0000 - 0xFFFE7FFF */
    FLASH_CF_BLOCK_10      = 0xFFFD8000,    /*  32KB: 0xFFFD8000 - 0xFFFDFFFF */
    FLASH_CF_BLOCK_11      = 0xFFFD0000,    /*  32KB: 0xFFFD0000 - 0xFFFD7FFF */
    FLASH_CF_BLOCK_12      = 0xFFFC8000,    /*  32KB: 0xFFFC8000 - 0xFFFCFFFF */
    FLASH_CF_BLOCK_13      = 0xFFFC0000,    /*  32KB: 0xFFFC0000 - 0xFFFC7FFF */
    FLASH_CF_BLOCK_14      = 0xFFFB8000,    /*  32KB: 0xFFFB8000 - 0xFFFBFFFF */
    FLASH_CF_BLOCK_15      = 0xFFFB0000,    /*  32KB: 0xFFFB0000 - 0xFFFB7FFF */
    FLASH_CF_BLOCK_16      = 0xFFFA8000,    /*  32KB: 0xFFFA8000 - 0xFFFAFFFF */
    FLASH_CF_BLOCK_17      = 0xFFFA0000,    /*  32KB: 0xFFFA0000 - 0xFFFA7FFF */
    FLASH_CF_BLOCK_18      = 0xFFF98000,    /*  32KB: 0xFFF98000 - 0xFFF9FFFF */
    FLASH_CF_BLOCK_19      = 0xFFF90000,    /*  32KB: 0xFFF90000 - 0xFFF97FFF */
    FLASH_CF_BLOCK_20      = 0xFFF88000,    /*  32KB: 0xFFF88000 - 0xFFF8FFFF */
    FLASH_CF_BLOCK_21      = 0xFFF80000,    /*  32KB: 0xFFF80000 - 0xFFF87FFF */
    FLASH_CF_BLOCK_22      = 0xFFF78000,    /*  32KB: 0xFFF78000 - 0xFFF7FFFF */
    FLASH_CF_BLOCK_23      = 0xFFF70000,    /*  32KB: 0xFFF70000 - 0xFFF77FFF */
    FLASH_CF_BLOCK_24      = 0xFFF68000,    /*  32KB: 0xFFF68000 - 0xFFF6FFFF */
    FLASH_CF_BLOCK_25      = 0xFFF60000,    /*  32KB: 0xFFF60000 - 0xFFF67FFF */
    FLASH_CF_BLOCK_26      = 0xFFF58000,    /*  32KB: 0xFFF58000 - 0xFFF5FFFF */
    FLASH_CF_BLOCK_27      = 0xFFF50000,    /*  32KB: 0xFFF50000 - 0xFFF57FFF */
    FLASH_CF_BLOCK_28      = 0xFFF48000,    /*  32KB: 0xFFF48000 - 0xFFF4FFFF */
    FLASH_CF_BLOCK_29      = 0xFFF40000,    /*  32KB: 0xFFF40000 - 0xFFF47FFF */
#if   MCU_CFG_PART_MEMORY_SIZE == 0x0C  /*   bank end for 'C' parts (1.5 Mb/bank) */
    FLASH_CF_HI_BANK_LO_ADDR = FLASH_CF_BLOCK_29,
#else
    FLASH_CF_BLOCK_30      = 0xFFF38000,    /*  32KB: 0xFFF38000 - 0xFFF3FFFF */
    FLASH_CF_BLOCK_31      = 0xFFF30000,    /*  32KB: 0xFFF30000 - 0xFFF37FFF */
    FLASH_CF_BLOCK_32      = 0xFFF28000,    /*  32KB: 0xFFF28000 - 0xFFF2FFFF */
    FLASH_CF_BLOCK_33      = 0xFFF20000,    /*  32KB: 0xFFF20000 - 0xFFF27FFF */
    FLASH_CF_BLOCK_34      = 0xFFF18000,    /*  32KB: 0xFFF18000 - 0xFFF1FFFF */
    FLASH_CF_BLOCK_35      = 0xFFF10000,    /*  32KB: 0xFFF10000 - 0xFFF17FFF */
    FLASH_CF_BLOCK_36      = 0xFFF08000,    /*  32KB: 0xFFF08000 - 0xFFF0FFFF */
    FLASH_CF_BLOCK_37      = 0xFFF00000,    /*  32KB: 0xFFF00000 - 0xFFF07FFF */
    FLASH_CF_HI_BANK_LO_ADDR = FLASH_CF_BLOCK_37,
#endif
    FLASH_CF_LO_BANK_HI_ADDR = 0xFFEFFFFF,  /* START OF NEXT BANK */

    FLASH_CF_BLOCK_38      = 0xFFEFE000,    /*   8KB: 0xFFEFE000 - 0xFFEFFFFF */
    FLASH_CF_BLOCK_39      = 0xFFEFC000,    /*   8KB: 0xFFEFC000 - 0xFFEFDFFF */
    FLASH_CF_BLOCK_40      = 0xFFEFA000,    /*   8KB: 0xFFEFA000 - 0xFFEEBFFF */
    FLASH_CF_BLOCK_41      = 0xFFEF8000,    /*   8KB: 0xFFEF8000 - 0xFFEF9FFF */
    FLASH_CF_BLOCK_42      = 0xFFEF6000,    /*   8KB: 0xFFEF6000 - 0xFFEF7FFF */
    FLASH_CF_BLOCK_43      = 0xFFEF4000,    /*   8KB: 0xFFEF4000 - 0xFFEF5FFF */
    FLASH_CF_BLOCK_44      = 0xFFEF2000,    /*   8KB: 0xFFEF2000 - 0xFFEF3FFF */
    FLASH_CF_BLOCK_45      = 0xFFEF0000,    /*   8KB: 0xFFEF0000 - 0xFFEF1FFF */
    FLASH_CF_BLOCK_46      = 0xFFEE8000,    /*  32KB: 0xFFEE8000 - 0xFFEEFFFF */
    FLASH_CF_BLOCK_47      = 0xFFEE0000,    /*  32KB: 0xFFEE0000 - 0xFFEE7FFF */
    FLASH_CF_BLOCK_48      = 0xFFED8000,    /*  32KB: 0xFFED8000 - 0xFFEDFFFF */
    FLASH_CF_BLOCK_49      = 0xFFED0000,    /*  32KB: 0xFFED0000 - 0xFFED7FFF */
    FLASH_CF_BLOCK_50      = 0xFFEC8000,    /*  32KB: 0xFFEC8000 - 0xFFECFFFF */
    FLASH_CF_BLOCK_51      = 0xFFEC0000,    /*  32KB: 0xFFEC0000 - 0xFFEC7FFF */
    FLASH_CF_BLOCK_52      = 0xFFEB8000,    /*  32KB: 0xFFEB8000 - 0xFFEBFFFF */
    FLASH_CF_BLOCK_53      = 0xFFEB0000,    /*  32KB: 0xFFEB0000 - 0xFFEB7FFF */
    FLASH_CF_BLOCK_54      = 0xFFEA8000,    /*  32KB: 0xFFEA8000 - 0xFFEAFFFF */
    FLASH_CF_BLOCK_55      = 0xFFEA0000,    /*  32KB: 0xFFEA0000 - 0xFFEA7FFF */
    FLASH_CF_BLOCK_56      = 0xFFE98000,    /*  32KB: 0xFFE98000 - 0xFFE9FFFF */
    FLASH_CF_BLOCK_57      = 0xFFE90000,    /*  32KB: 0xFFE90000 - 0xFFE97FFF */
    FLASH_CF_BLOCK_58      = 0xFFE88000,    /*  32KB: 0xFFE88000 - 0xFFE8FFFF */
    FLASH_CF_BLOCK_59      = 0xFFE80000,    /*  32KB: 0xFFE80000 - 0xFFE87FFF */
    FLASH_CF_BLOCK_60      = 0xFFE78000,    /*  32KB: 0xFFE78000 - 0xFFE7FFFF */
    FLASH_CF_BLOCK_61      = 0xFFE70000,    /*  32KB: 0xFFE70000 - 0xFFE77FFF */
    FLASH_CF_BLOCK_62      = 0xFFE68000,    /*  32KB: 0xFFE68000 - 0xFFE6FFFF */
    FLASH_CF_BLOCK_63      = 0xFFE60000,    /*  32KB: 0xFFE60000 - 0xFFE67FFF */
    FLASH_CF_BLOCK_64      = 0xFFE58000,    /*  32KB: 0xFFE58000 - 0xFFE5FFFF */
    FLASH_CF_BLOCK_65      = 0xFFE50000,    /*  32KB: 0xFFE50000 - 0xFFE57FFF */
    FLASH_CF_BLOCK_66      = 0xFFE48000,    /*  32KB: 0xFFE48000 - 0xFFE4FFFF */
    FLASH_CF_BLOCK_67      = 0xFFE40000,    /*  32KB: 0xFFE40000 - 0xFFE47FFF */
#if   MCU_CFG_PART_MEMORY_SIZE == 0x0C  /*   bank end for 'C' parts (1.5 Mb/bank) */
    FLASH_CF_LO_BANK_LO_ADDR = FLASH_CF_BLOCK_67,
    FLASH_CF_BLOCK_INVALID = (FLASH_CF_BLOCK_67 - 1),
#else
    FLASH_CF_BLOCK_68      = 0xFFE38000,    /*  32KB: 0xFFE38000 - 0xFFE3FFFF */
    FLASH_CF_BLOCK_69      = 0xFFE30000,    /*  32KB: 0xFFE30000 - 0xFFE37FFF */
    FLASH_CF_BLOCK_70      = 0xFFE28000,    /*  32KB: 0xFFE28000 - 0xFFE2FFFF */
    FLASH_CF_BLOCK_71      = 0xFFE20000,    /*  32KB: 0xFFE20000 - 0xFFE27FFF */
    FLASH_CF_BLOCK_72      = 0xFFE18000,    /*  32KB: 0xFFE18000 - 0xFFE1FFFF */
    FLASH_CF_BLOCK_73      = 0xFFE10000,    /*  32KB: 0xFFE10000 - 0xFFE17FFF */
    FLASH_CF_BLOCK_74      = 0xFFE08000,    /*  32KB: 0xFFE08000 - 0xFFE0FFFF */
    FLASH_CF_BLOCK_75      = 0xFFE00000,    /*  32KB: 0xFFE00000 - 0xFFE07FFF */
    FLASH_CF_LO_BANK_LO_ADDR = FLASH_CF_BLOCK_75,
    FLASH_CF_BLOCK_INVALID = (FLASH_CF_BLOCK_75 - 1),
#endif // 8 blocks for 2M only
#endif // DUAL MODE

#if (MCU_DATA_FLASH_SIZE_BYTES != 0)
    FLASH_DF_BLOCK_0       = 0x00100000,    /*   64B: 0x00100000 - 0x0010003F */
    FLASH_DF_BLOCK_1       = 0x00100040,    /*   64B: 0x00100040 - 0x0010007F */
    FLASH_DF_BLOCK_2       = 0x00100080,    /*   64B: 0x00100080 - 0x001000BF */
    FLASH_DF_BLOCK_3       = 0x001000C0,    /*   64B: 0x001000C0 - 0x001000FF */
    FLASH_DF_BLOCK_4       = 0x00100100,    /*   64B: 0x00100100 - 0x0010013F */
    FLASH_DF_BLOCK_5       = 0x00100140,    /*   64B: 0x00100140 - 0x0010017F */
    FLASH_DF_BLOCK_6       = 0x00100180,    /*   64B: 0x00100180 - 0x001001BF */
    FLASH_DF_BLOCK_7       = 0x001001C0,    /*   64B: 0x001001C0 - 0x001001FF */
    FLASH_DF_BLOCK_8       = 0x00100200,    /*   64B: 0x00100200 - 0x0010023F */
    FLASH_DF_BLOCK_9       = 0x00100240,    /*   64B: 0x00100240 - 0x0010027F */
    FLASH_DF_BLOCK_10      = 0x00100280,    /*   64B: 0x00100280 - 0x001002BF */
    FLASH_DF_BLOCK_11      = 0x001002C0,    /*   64B: 0x001002C0 - 0x001002FF */
    FLASH_DF_BLOCK_12      = 0x00100300,    /*   64B: 0x00100300 - 0x0010033F */
    FLASH_DF_BLOCK_13      = 0x00100340,    /*   64B: 0x00100340 - 0x0010037F */
    FLASH_DF_BLOCK_14      = 0x00100380,    /*   64B: 0x00100380 - 0x001003BF */
    FLASH_DF_BLOCK_15      = 0x001003C0,    /*   64B: 0x001003C0 - 0x001003FF */
    FLASH_DF_BLOCK_16      = 0x00100400,    /*   64B: 0x00100400 - 0x0010043F */
    FLASH_DF_BLOCK_17      = 0x00100440,    /*   64B: 0x00100440 - 0x0010047F */
    FLASH_DF_BLOCK_18      = 0x00100480,    /*   64B: 0x00100480 - 0x001004BF */
    FLASH_DF_BLOCK_19      = 0x001004C0,    /*   64B: 0x001004C0 - 0x001004FF */
    FLASH_DF_BLOCK_20      = 0x00100500,    /*   64B: 0x00100500 - 0x0010053F */
    FLASH_DF_BLOCK_21      = 0x00100540,    /*   64B: 0x00100540 - 0x0010057F */
    FLASH_DF_BLOCK_22      = 0x00100580,    /*   64B: 0x00100580 - 0x001005BF */
    FLASH_DF_BLOCK_23      = 0x001005C0,    /*   64B: 0x001005C0 - 0x001005FF */
    FLASH_DF_BLOCK_24      = 0x00100600,    /*   64B: 0x00100600 - 0x0010063F */
    FLASH_DF_BLOCK_25      = 0x00100640,    /*   64B: 0x00100640 - 0x0010067F */
    FLASH_DF_BLOCK_26      = 0x00100680,    /*   64B: 0x00100680 - 0x001006BF */
    FLASH_DF_BLOCK_27      = 0x001006C0,    /*   64B: 0x001006C0 - 0x001006FF */
    FLASH_DF_BLOCK_28      = 0x00100700,    /*   64B: 0x00100700 - 0x0010073F */
    FLASH_DF_BLOCK_29      = 0x00100740,    /*   64B: 0x00100740 - 0x0010077F */
    FLASH_DF_BLOCK_30      = 0x00100780,    /*   64B: 0x00100780 - 0x001007BF */
    FLASH_DF_BLOCK_31      = 0x001007C0,    /*   64B: 0x001007C0 - 0x001007FF */
    FLASH_DF_BLOCK_32      = 0x00100800,    /*   64B: 0x00100800 - 0x0010083F */
    FLASH_DF_BLOCK_33      = 0x00100840,    /*   64B: 0x00100840 - 0x0010087F */
    FLASH_DF_BLOCK_34      = 0x00100880,    /*   64B: 0x00100880 - 0x001008BF */
    FLASH_DF_BLOCK_35      = 0x001008C0,    /*   64B: 0x001008C0 - 0x001008FF */
    FLASH_DF_BLOCK_36      = 0x00100900,    /*   64B: 0x00100900 - 0x0010093F */
    FLASH_DF_BLOCK_37      = 0x00100940,    /*   64B: 0x00100940 - 0x0010097F */
    FLASH_DF_BLOCK_38      = 0x00100980,    /*   64B: 0x00100980 - 0x001009BF */
    FLASH_DF_BLOCK_39      = 0x001009C0,    /*   64B: 0x001009C0 - 0x001009FF */
    FLASH_DF_BLOCK_40      = 0x00100A00,    /*   64B: 0x00100A00 - 0x00100A3F */
    FLASH_DF_BLOCK_41      = 0x00100A40,    /*   64B: 0x00100A40 - 0x00100A7F */
    FLASH_DF_BLOCK_42      = 0x00100A80,    /*   64B: 0x00100A80 - 0x00100ABF */
    FLASH_DF_BLOCK_43      = 0x00100AC0,    /*   64B: 0x00100AC0 - 0x00100AFF */
    FLASH_DF_BLOCK_44      = 0x00100B00,    /*   64B: 0x00100B00 - 0x00100B3F */
    FLASH_DF_BLOCK_45      = 0x00100B40,    /*   64B: 0x00100B40 - 0x00100B7F */
    FLASH_DF_BLOCK_46      = 0x00100B80,    /*   64B: 0x00100B80 - 0x00100BBF */
    FLASH_DF_BLOCK_47      = 0x00100BC0,    /*   64B: 0x00100BC0 - 0x00100BFF */
    FLASH_DF_BLOCK_48      = 0x00100C00,    /*   64B: 0x00100C00 - 0x00100C3F */
    FLASH_DF_BLOCK_49      = 0x00100C40,    /*   64B: 0x00100C40 - 0x00100C7F */
    FLASH_DF_BLOCK_50      = 0x00100C80,    /*   64B: 0x00100C80 - 0x00100CBF */
    FLASH_DF_BLOCK_51      = 0x00100CC0,    /*   64B: 0x00100CC0 - 0x00100CFF */
    FLASH_DF_BLOCK_52      = 0x00100D00,    /*   64B: 0x00100D00 - 0x00100D3F */
    FLASH_DF_BLOCK_53      = 0x00100D40,    /*   64B: 0x00100D40 - 0x00100D7F */
    FLASH_DF_BLOCK_54      = 0x00100D80,    /*   64B: 0x00100D80 - 0x00100DBF */
    FLASH_DF_BLOCK_55      = 0x00100DC0,    /*   64B: 0x00100DC0 - 0x00100DFF */
    FLASH_DF_BLOCK_56      = 0x00100E00,    /*   64B: 0x00100E00 - 0x00100E3F */
    FLASH_DF_BLOCK_57      = 0x00100E40,    /*   64B: 0x00100E40 - 0x00100E7F */
    FLASH_DF_BLOCK_58      = 0x00100E80,    /*   64B: 0x00100E80 - 0x00100EBF */
    FLASH_DF_BLOCK_59      = 0x00100EC0,    /*   64B: 0x00100EC0 - 0x00100EFF */
    FLASH_DF_BLOCK_60      = 0x00100F00,    /*   64B: 0x00100F00 - 0x00100F3F */
    FLASH_DF_BLOCK_61      = 0x00100F40,    /*   64B: 0x00100F40 - 0x00100F7F */
    FLASH_DF_BLOCK_62      = 0x00100F80,    /*   64B: 0x00100F80 - 0x00100FBF */
    FLASH_DF_BLOCK_63      = 0x00100FC0,    /*   64B: 0x00100FC0 - 0x00100FFF */
    FLASH_DF_BLOCK_64      = 0x00101000,    /*   64B: 0x00101000 - 0x0010103F */
    FLASH_DF_BLOCK_65      = 0x00101040,    /*   64B: 0x00101040 - 0x0010107F */
    FLASH_DF_BLOCK_66      = 0x00101080,    /*   64B: 0x00101080 - 0x001010BF */
    FLASH_DF_BLOCK_67      = 0x001010C0,    /*   64B: 0x001010C0 - 0x001010FF */
    FLASH_DF_BLOCK_68      = 0x00101100,    /*   64B: 0x00101100 - 0x0010113F */
    FLASH_DF_BLOCK_69      = 0x00101140,    /*   64B: 0x00101140 - 0x0010117F */
    FLASH_DF_BLOCK_70      = 0x00101180,    /*   64B: 0x00101180 - 0x001011BF */
    FLASH_DF_BLOCK_71      = 0x001011C0,    /*   64B: 0x001011C0 - 0x001011FF */
    FLASH_DF_BLOCK_72      = 0x00101200,    /*   64B: 0x00101200 - 0x0010123F */
    FLASH_DF_BLOCK_73      = 0x00101240,    /*   64B: 0x00101240 - 0x0010127F */
    FLASH_DF_BLOCK_74      = 0x00101280,    /*   64B: 0x00101280 - 0x001012BF */
    FLASH_DF_BLOCK_75      = 0x001012C0,    /*   64B: 0x001012C0 - 0x001012FF */
    FLASH_DF_BLOCK_76      = 0x00101300,    /*   64B: 0x00101300 - 0x0010133F */
    FLASH_DF_BLOCK_77      = 0x00101340,    /*   64B: 0x00101340 - 0x0010137F */
    FLASH_DF_BLOCK_78      = 0x00101380,    /*   64B: 0x00101380 - 0x001013BF */
    FLASH_DF_BLOCK_79      = 0x001013C0,    /*   64B: 0x001013C0 - 0x001013FF */
    FLASH_DF_BLOCK_80      = 0x00101400,    /*   64B: 0x00101400 - 0x0010143F */
    FLASH_DF_BLOCK_81      = 0x00101440,    /*   64B: 0x00101440 - 0x0010147F */
    FLASH_DF_BLOCK_82      = 0x00101480,    /*   64B: 0x00101480 - 0x001014BF */
    FLASH_DF_BLOCK_83      = 0x001014C0,    /*   64B: 0x001014C0 - 0x001014FF */
    FLASH_DF_BLOCK_84      = 0x00101500,    /*   64B: 0x00101500 - 0x0010153F */
    FLASH_DF_BLOCK_85      = 0x00101540,    /*   64B: 0x00101540 - 0x0010157F */
    FLASH_DF_BLOCK_86      = 0x00101580,    /*   64B: 0x00101580 - 0x001015BF */
    FLASH_DF_BLOCK_87      = 0x001015C0,    /*   64B: 0x001015C0 - 0x001015FF */
    FLASH_DF_BLOCK_88      = 0x00101600,    /*   64B: 0x00101600 - 0x0010163F */
    FLASH_DF_BLOCK_89      = 0x00101640,    /*   64B: 0x00101640 - 0x0010167F */
    FLASH_DF_BLOCK_90      = 0x00101680,    /*   64B: 0x00101680 - 0x001016BF */
    FLASH_DF_BLOCK_91      = 0x001016C0,    /*   64B: 0x001016C0 - 0x001016FF */
    FLASH_DF_BLOCK_92      = 0x00101700,    /*   64B: 0x00101700 - 0x0010173F */
    FLASH_DF_BLOCK_93      = 0x00101740,    /*   64B: 0x00101740 - 0x0010177F */
    FLASH_DF_BLOCK_94      = 0x00101780,    /*   64B: 0x00101780 - 0x001017BF */
    FLASH_DF_BLOCK_95      = 0x001017C0,    /*   64B: 0x001017C0 - 0x001017FF */
    FLASH_DF_BLOCK_96      = 0x00101800,    /*   64B: 0x00101800 - 0x0010183F */
    FLASH_DF_BLOCK_97      = 0x00101840,    /*   64B: 0x00101840 - 0x0010187F */
    FLASH_DF_BLOCK_98      = 0x00101880,    /*   64B: 0x00101880 - 0x001018BF */
    FLASH_DF_BLOCK_99      = 0x001018C0,    /*   64B: 0x001018C0 - 0x001018FF */
    FLASH_DF_BLOCK_100     = 0x00101900,    /*   64B: 0x00101900 - 0x0010193F */
    FLASH_DF_BLOCK_101     = 0x00101940,    /*   64B: 0x00101940 - 0x0010197F */
    FLASH_DF_BLOCK_102     = 0x00101980,    /*   64B: 0x00101980 - 0x001019BF */
    FLASH_DF_BLOCK_103     = 0x001019C0,    /*   64B: 0x001019C0 - 0x001019FF */
    FLASH_DF_BLOCK_104     = 0x00101A00,    /*   64B: 0x00101A00 - 0x00101A3F */
    FLASH_DF_BLOCK_105     = 0x00101A40,    /*   64B: 0x00101A40 - 0x00101A7F */
    FLASH_DF_BLOCK_106     = 0x00101A80,    /*   64B: 0x00101A80 - 0x00101ABF */
    FLASH_DF_BLOCK_107     = 0x00101AC0,    /*   64B: 0x00101AC0 - 0x00101AFF */
    FLASH_DF_BLOCK_108     = 0x00101B00,    /*   64B: 0x00101B00 - 0x00101B3F */
    FLASH_DF_BLOCK_109     = 0x00101B40,    /*   64B: 0x00101B40 - 0x00101B7F */
    FLASH_DF_BLOCK_110     = 0x00101B80,    /*   64B: 0x00101B80 - 0x00101BBF */
    FLASH_DF_BLOCK_111     = 0x00101BC0,    /*   64B: 0x00101BC0 - 0x00101BFF */
    FLASH_DF_BLOCK_112     = 0x00101C00,    /*   64B: 0x00101C00 - 0x00101C3F */
    FLASH_DF_BLOCK_113     = 0x00101C40,    /*   64B: 0x00101C40 - 0x00101C7F */
    FLASH_DF_BLOCK_114     = 0x00101C80,    /*   64B: 0x00101C80 - 0x00101CBF */
    FLASH_DF_BLOCK_115     = 0x00101CC0,    /*   64B: 0x00101CC0 - 0x00101CFF */
    FLASH_DF_BLOCK_116     = 0x00101D00,    /*   64B: 0x00101D00 - 0x00101D3F */
    FLASH_DF_BLOCK_117     = 0x00101D40,    /*   64B: 0x00101D40 - 0x00101D7F */
    FLASH_DF_BLOCK_118     = 0x00101D80,    /*   64B: 0x00101D80 - 0x00101DBF */
    FLASH_DF_BLOCK_119     = 0x00101DC0,    /*   64B: 0x00101DC0 - 0x00101DFF */
    FLASH_DF_BLOCK_120     = 0x00101E00,    /*   64B: 0x00101E00 - 0x00101E3F */
    FLASH_DF_BLOCK_121     = 0x00101E40,    /*   64B: 0x00101E40 - 0x00101E7F */
    FLASH_DF_BLOCK_122     = 0x00101E80,    /*   64B: 0x00101E80 - 0x00101EBF */
    FLASH_DF_BLOCK_123     = 0x00101EC0,    /*   64B: 0x00101EC0 - 0x00101EFF */
    FLASH_DF_BLOCK_124     = 0x00101F00,    /*   64B: 0x00101F00 - 0x00101F3F */
    FLASH_DF_BLOCK_125     = 0x00101F40,    /*   64B: 0x00101F40 - 0x00101F7F */
    FLASH_DF_BLOCK_126     = 0x00101F80,    /*   64B: 0x00101F80 - 0x00101FBF */
    FLASH_DF_BLOCK_127     = 0x00101FC0,    /*   64B: 0x00101FC0 - 0x00101FFF */
    FLASH_DF_BLOCK_128     = 0x00102000,    /*   64B: 0x00102000 - 0x0010203F */
    FLASH_DF_BLOCK_129     = 0x00102040,    /*   64B: 0x00102040 - 0x0010207F */
    FLASH_DF_BLOCK_130     = 0x00102080,    /*   64B: 0x00102080 - 0x001020BF */
    FLASH_DF_BLOCK_131     = 0x001020C0,    /*   64B: 0x001020C0 - 0x001020FF */
    FLASH_DF_BLOCK_132     = 0x00102100,    /*   64B: 0x00102100 - 0x0010213F */
    FLASH_DF_BLOCK_133     = 0x00102140,    /*   64B: 0x00102140 - 0x0010217F */
    FLASH_DF_BLOCK_134     = 0x00102180,    /*   64B: 0x00102180 - 0x001021BF */
    FLASH_DF_BLOCK_135     = 0x001021C0,    /*   64B: 0x001021C0 - 0x001021FF */
    FLASH_DF_BLOCK_136     = 0x00102200,    /*   64B: 0x00102200 - 0x0010223F */
    FLASH_DF_BLOCK_137     = 0x00102240,    /*   64B: 0x00102240 - 0x0010227F */
    FLASH_DF_BLOCK_138     = 0x00102280,    /*   64B: 0x00102280 - 0x001022BF */
    FLASH_DF_BLOCK_139     = 0x001022C0,    /*   64B: 0x001022C0 - 0x001022FF */
    FLASH_DF_BLOCK_140     = 0x00102300,    /*   64B: 0x00102300 - 0x0010233F */
    FLASH_DF_BLOCK_141     = 0x00102340,    /*   64B: 0x00102340 - 0x0010237F */
    FLASH_DF_BLOCK_142     = 0x00102380,    /*   64B: 0x00102380 - 0x001023BF */
    FLASH_DF_BLOCK_143     = 0x001023C0,    /*   64B: 0x001023C0 - 0x001023FF */
    FLASH_DF_BLOCK_144     = 0x00102400,    /*   64B: 0x00102400 - 0x0010243F */
    FLASH_DF_BLOCK_145     = 0x00102440,    /*   64B: 0x00102440 - 0x0010247F */
    FLASH_DF_BLOCK_146     = 0x00102480,    /*   64B: 0x00102480 - 0x001024BF */
    FLASH_DF_BLOCK_147     = 0x001024C0,    /*   64B: 0x001024C0 - 0x001024FF */
    FLASH_DF_BLOCK_148     = 0x00102500,    /*   64B: 0x00102500 - 0x0010253F */
    FLASH_DF_BLOCK_149     = 0x00102540,    /*   64B: 0x00102540 - 0x0010257F */
    FLASH_DF_BLOCK_150     = 0x00102580,    /*   64B: 0x00102580 - 0x001025BF */
    FLASH_DF_BLOCK_151     = 0x001025C0,    /*   64B: 0x001025C0 - 0x001025FF */
    FLASH_DF_BLOCK_152     = 0x00102600,    /*   64B: 0x00102600 - 0x0010263F */
    FLASH_DF_BLOCK_153     = 0x00102640,    /*   64B: 0x00102640 - 0x0010267F */
    FLASH_DF_BLOCK_154     = 0x00102680,    /*   64B: 0x00102680 - 0x001026BF */
    FLASH_DF_BLOCK_155     = 0x001026C0,    /*   64B: 0x001026C0 - 0x001026FF */
    FLASH_DF_BLOCK_156     = 0x00102700,    /*   64B: 0x00102700 - 0x0010273F */
    FLASH_DF_BLOCK_157     = 0x00102740,    /*   64B: 0x00102740 - 0x0010277F */
    FLASH_DF_BLOCK_158     = 0x00102780,    /*   64B: 0x00102780 - 0x001027BF */
    FLASH_DF_BLOCK_159     = 0x001027C0,    /*   64B: 0x001027C0 - 0x001027FF */
    FLASH_DF_BLOCK_160     = 0x00102800,    /*   64B: 0x00102800 - 0x0010283F */
    FLASH_DF_BLOCK_161     = 0x00102840,    /*   64B: 0x00102840 - 0x0010287F */
    FLASH_DF_BLOCK_162     = 0x00102880,    /*   64B: 0x00102880 - 0x001028BF */
    FLASH_DF_BLOCK_163     = 0x001028C0,    /*   64B: 0x001028C0 - 0x001028FF */
    FLASH_DF_BLOCK_164     = 0x00102900,    /*   64B: 0x00102900 - 0x0010293F */
    FLASH_DF_BLOCK_165     = 0x00102940,    /*   64B: 0x00102940 - 0x0010297F */
    FLASH_DF_BLOCK_166     = 0x00102980,    /*   64B: 0x00102980 - 0x001029BF */
    FLASH_DF_BLOCK_167     = 0x001029C0,    /*   64B: 0x001029C0 - 0x001029FF */
    FLASH_DF_BLOCK_168     = 0x00102A00,    /*   64B: 0x00102A00 - 0x00102A3F */
    FLASH_DF_BLOCK_169     = 0x00102A40,    /*   64B: 0x00102A40 - 0x00102A7F */
    FLASH_DF_BLOCK_170     = 0x00102A80,    /*   64B: 0x00102A80 - 0x00102ABF */
    FLASH_DF_BLOCK_171     = 0x00102AC0,    /*   64B: 0x00102AC0 - 0x00102AFF */
    FLASH_DF_BLOCK_172     = 0x00102B00,    /*   64B: 0x00102B00 - 0x00102B3F */
    FLASH_DF_BLOCK_173     = 0x00102B40,    /*   64B: 0x00102B40 - 0x00102B7F */
    FLASH_DF_BLOCK_174     = 0x00102B80,    /*   64B: 0x00102B80 - 0x00102BBF */
    FLASH_DF_BLOCK_175     = 0x00102BC0,    /*   64B: 0x00102BC0 - 0x00102BFF */
    FLASH_DF_BLOCK_176     = 0x00102C00,    /*   64B: 0x00102C00 - 0x00102C3F */
    FLASH_DF_BLOCK_177     = 0x00102C40,    /*   64B: 0x00102C40 - 0x00102C7F */
    FLASH_DF_BLOCK_178     = 0x00102C80,    /*   64B: 0x00102C80 - 0x00102CBF */
    FLASH_DF_BLOCK_179     = 0x00102CC0,    /*   64B: 0x00102CC0 - 0x00102CFF */
    FLASH_DF_BLOCK_180     = 0x00102D00,    /*   64B: 0x00102D00 - 0x00102D3F */
    FLASH_DF_BLOCK_181     = 0x00102D40,    /*   64B: 0x00102D40 - 0x00102D7F */
    FLASH_DF_BLOCK_182     = 0x00102D80,    /*   64B: 0x00102D80 - 0x00102DBF */
    FLASH_DF_BLOCK_183     = 0x00102DC0,    /*   64B: 0x00102DC0 - 0x00102DFF */
    FLASH_DF_BLOCK_184     = 0x00102E00,    /*   64B: 0x00102E00 - 0x00102E3F */
    FLASH_DF_BLOCK_185     = 0x00102E40,    /*   64B: 0x00102E40 - 0x00102E7F */
    FLASH_DF_BLOCK_186     = 0x00102E80,    /*   64B: 0x00102E80 - 0x00102EBF */
    FLASH_DF_BLOCK_187     = 0x00102EC0,    /*   64B: 0x00102EC0 - 0x00102EFF */
    FLASH_DF_BLOCK_188     = 0x00102F00,    /*   64B: 0x00102F00 - 0x00102F3F */
    FLASH_DF_BLOCK_189     = 0x00102F40,    /*   64B: 0x00102F40 - 0x00102F7F */
    FLASH_DF_BLOCK_190     = 0x00102F80,    /*   64B: 0x00102F80 - 0x00102FBF */
    FLASH_DF_BLOCK_191     = 0x00102FC0,    /*   64B: 0x00102FC0 - 0x00102FFF */
    FLASH_DF_BLOCK_192     = 0x00103000,    /*   64B: 0x00103000 - 0x0010303F */
    FLASH_DF_BLOCK_193     = 0x00103040,    /*   64B: 0x00103040 - 0x0010307F */
    FLASH_DF_BLOCK_194     = 0x00103080,    /*   64B: 0x00103080 - 0x001030BF */
    FLASH_DF_BLOCK_195     = 0x001030C0,    /*   64B: 0x001030C0 - 0x001030FF */
    FLASH_DF_BLOCK_196     = 0x00103100,    /*   64B: 0x00103100 - 0x0010313F */
    FLASH_DF_BLOCK_197     = 0x00103140,    /*   64B: 0x00103140 - 0x0010317F */
    FLASH_DF_BLOCK_198     = 0x00103180,    /*   64B: 0x00103180 - 0x001031BF */
    FLASH_DF_BLOCK_199     = 0x001031C0,    /*   64B: 0x001031C0 - 0x001031FF */
    FLASH_DF_BLOCK_200     = 0x00103200,    /*   64B: 0x00103200 - 0x0010323F */
    FLASH_DF_BLOCK_201     = 0x00103240,    /*   64B: 0x00103240 - 0x0010327F */
    FLASH_DF_BLOCK_202     = 0x00103280,    /*   64B: 0x00103280 - 0x001032BF */
    FLASH_DF_BLOCK_203     = 0x001032C0,    /*   64B: 0x001032C0 - 0x001032FF */
    FLASH_DF_BLOCK_204     = 0x00103300,    /*   64B: 0x00103300 - 0x0010333F */
    FLASH_DF_BLOCK_205     = 0x00103340,    /*   64B: 0x00103340 - 0x0010337F */
    FLASH_DF_BLOCK_206     = 0x00103380,    /*   64B: 0x00103380 - 0x001033BF */
    FLASH_DF_BLOCK_207     = 0x001033C0,    /*   64B: 0x001033C0 - 0x001033FF */
    FLASH_DF_BLOCK_208     = 0x00103400,    /*   64B: 0x00103400 - 0x0010343F */
    FLASH_DF_BLOCK_209     = 0x00103440,    /*   64B: 0x00103440 - 0x0010347F */
    FLASH_DF_BLOCK_210     = 0x00103480,    /*   64B: 0x00103480 - 0x001034BF */
    FLASH_DF_BLOCK_211     = 0x001034C0,    /*   64B: 0x001034C0 - 0x001034FF */
    FLASH_DF_BLOCK_212     = 0x00103500,    /*   64B: 0x00103500 - 0x0010353F */
    FLASH_DF_BLOCK_213     = 0x00103540,    /*   64B: 0x00103540 - 0x0010357F */
    FLASH_DF_BLOCK_214     = 0x00103580,    /*   64B: 0x00103580 - 0x001035BF */
    FLASH_DF_BLOCK_215     = 0x001035C0,    /*   64B: 0x001035C0 - 0x001035FF */
    FLASH_DF_BLOCK_216     = 0x00103600,    /*   64B: 0x00103600 - 0x0010363F */
    FLASH_DF_BLOCK_217     = 0x00103640,    /*   64B: 0x00103640 - 0x0010367F */
    FLASH_DF_BLOCK_218     = 0x00103680,    /*   64B: 0x00103680 - 0x001036BF */
    FLASH_DF_BLOCK_219     = 0x001036C0,    /*   64B: 0x001036C0 - 0x001036FF */
    FLASH_DF_BLOCK_220     = 0x00103700,    /*   64B: 0x00103700 - 0x0010373F */
    FLASH_DF_BLOCK_221     = 0x00103740,    /*   64B: 0x00103740 - 0x0010377F */
    FLASH_DF_BLOCK_222     = 0x00103780,    /*   64B: 0x00103780 - 0x001037BF */
    FLASH_DF_BLOCK_223     = 0x001037C0,    /*   64B: 0x001037C0 - 0x001037FF */
    FLASH_DF_BLOCK_224     = 0x00103800,    /*   64B: 0x00103800 - 0x0010383F */
    FLASH_DF_BLOCK_225     = 0x00103840,    /*   64B: 0x00103840 - 0x0010387F */
    FLASH_DF_BLOCK_226     = 0x00103880,    /*   64B: 0x00103880 - 0x001038BF */
    FLASH_DF_BLOCK_227     = 0x001038C0,    /*   64B: 0x001038C0 - 0x001038FF */
    FLASH_DF_BLOCK_228     = 0x00103900,    /*   64B: 0x00103900 - 0x0010393F */
    FLASH_DF_BLOCK_229     = 0x00103940,    /*   64B: 0x00103940 - 0x0010397F */
    FLASH_DF_BLOCK_230     = 0x00103980,    /*   64B: 0x00103980 - 0x001039BF */
    FLASH_DF_BLOCK_231     = 0x001039C0,    /*   64B: 0x001039C0 - 0x001039FF */
    FLASH_DF_BLOCK_232     = 0x00103A00,    /*   64B: 0x00103A00 - 0x00103A3F */
    FLASH_DF_BLOCK_233     = 0x00103A40,    /*   64B: 0x00103A40 - 0x00103A7F */
    FLASH_DF_BLOCK_234     = 0x00103A80,    /*   64B: 0x00103A80 - 0x00103ABF */
    FLASH_DF_BLOCK_235     = 0x00103AC0,    /*   64B: 0x00103AC0 - 0x00103AFF */
    FLASH_DF_BLOCK_236     = 0x00103B00,    /*   64B: 0x00103B00 - 0x00103B3F */
    FLASH_DF_BLOCK_237     = 0x00103B40,    /*   64B: 0x00103B40 - 0x00103B7F */
    FLASH_DF_BLOCK_238     = 0x00103B80,    /*   64B: 0x00103B80 - 0x00103BBF */
    FLASH_DF_BLOCK_239     = 0x00103BC0,    /*   64B: 0x00103BC0 - 0x00103BFF */
    FLASH_DF_BLOCK_240     = 0x00103C00,    /*   64B: 0x00103C00 - 0x00103C3F */
    FLASH_DF_BLOCK_241     = 0x00103C40,    /*   64B: 0x00103C40 - 0x00103C7F */
    FLASH_DF_BLOCK_242     = 0x00103C80,    /*   64B: 0x00103C80 - 0x00103CBF */
    FLASH_DF_BLOCK_243     = 0x00103CC0,    /*   64B: 0x00103CC0 - 0x00103CFF */
    FLASH_DF_BLOCK_244     = 0x00103D00,    /*   64B: 0x00103D00 - 0x00103D3F */
    FLASH_DF_BLOCK_245     = 0x00103D40,    /*   64B: 0x00103D40 - 0x00103D7F */
    FLASH_DF_BLOCK_246     = 0x00103D80,    /*   64B: 0x00103D80 - 0x00103DBF */
    FLASH_DF_BLOCK_247     = 0x00103DC0,    /*   64B: 0x00103DC0 - 0x00103DFF */
    FLASH_DF_BLOCK_248     = 0x00103E00,    /*   64B: 0x00103E00 - 0x00103E3F */
    FLASH_DF_BLOCK_249     = 0x00103E40,    /*   64B: 0x00103E40 - 0x00103E7F */
    FLASH_DF_BLOCK_250     = 0x00103E80,    /*   64B: 0x00103E80 - 0x00103EBF */
    FLASH_DF_BLOCK_251     = 0x00103EC0,    /*   64B: 0x00103EC0 - 0x00103EFF */
    FLASH_DF_BLOCK_252     = 0x00103F00,    /*   64B: 0x00103F00 - 0x00103F3F */
    FLASH_DF_BLOCK_253     = 0x00103F40,    /*   64B: 0x00103F40 - 0x00103F7F */
    FLASH_DF_BLOCK_254     = 0x00103F80,    /*   64B: 0x00103F80 - 0x00103FBF */
    FLASH_DF_BLOCK_255     = 0x00103FC0,    /*   64B: 0x00103FC0 - 0x00103FFF */
    FLASH_DF_BLOCK_256     = 0x00104000,    /*   64B: 0x00104000 - 0x0010403F */
    FLASH_DF_BLOCK_257     = 0x00104040,    /*   64B: 0x00104040 - 0x0010407F */
    FLASH_DF_BLOCK_258     = 0x00104080,    /*   64B: 0x00104080 - 0x001040BF */
    FLASH_DF_BLOCK_259     = 0x001040C0,    /*   64B: 0x001040C0 - 0x001040FF */
    FLASH_DF_BLOCK_260     = 0x00104100,    /*   64B: 0x00104100 - 0x0010413F */
    FLASH_DF_BLOCK_261     = 0x00104140,    /*   64B: 0x00104140 - 0x0010417F */
    FLASH_DF_BLOCK_262     = 0x00104180,    /*   64B: 0x00104180 - 0x001041BF */
    FLASH_DF_BLOCK_263     = 0x001041C0,    /*   64B: 0x001041C0 - 0x001041FF */
    FLASH_DF_BLOCK_264     = 0x00104200,    /*   64B: 0x00104200 - 0x0010423F */
    FLASH_DF_BLOCK_265     = 0x00104240,    /*   64B: 0x00104240 - 0x0010427F */
    FLASH_DF_BLOCK_266     = 0x00104280,    /*   64B: 0x00104280 - 0x001042BF */
    FLASH_DF_BLOCK_267     = 0x001042C0,    /*   64B: 0x001042C0 - 0x001042FF */
    FLASH_DF_BLOCK_268     = 0x00104300,    /*   64B: 0x00104300 - 0x0010433F */
    FLASH_DF_BLOCK_269     = 0x00104340,    /*   64B: 0x00104340 - 0x0010437F */
    FLASH_DF_BLOCK_270     = 0x00104380,    /*   64B: 0x00104380 - 0x001043BF */
    FLASH_DF_BLOCK_271     = 0x001043C0,    /*   64B: 0x001043C0 - 0x001043FF */
    FLASH_DF_BLOCK_272     = 0x00104400,    /*   64B: 0x00104400 - 0x0010443F */
    FLASH_DF_BLOCK_273     = 0x00104440,    /*   64B: 0x00104440 - 0x0010447F */
    FLASH_DF_BLOCK_274     = 0x00104480,    /*   64B: 0x00104480 - 0x001044BF */
    FLASH_DF_BLOCK_275     = 0x001044C0,    /*   64B: 0x001044C0 - 0x001044FF */
    FLASH_DF_BLOCK_276     = 0x00104500,    /*   64B: 0x00104500 - 0x0010453F */
    FLASH_DF_BLOCK_277     = 0x00104540,    /*   64B: 0x00104540 - 0x0010457F */
    FLASH_DF_BLOCK_278     = 0x00104580,    /*   64B: 0x00104580 - 0x001045BF */
    FLASH_DF_BLOCK_279     = 0x001045C0,    /*   64B: 0x001045C0 - 0x001045FF */
    FLASH_DF_BLOCK_280     = 0x00104600,    /*   64B: 0x00104600 - 0x0010463F */
    FLASH_DF_BLOCK_281     = 0x00104640,    /*   64B: 0x00104640 - 0x0010467F */
    FLASH_DF_BLOCK_282     = 0x00104680,    /*   64B: 0x00104680 - 0x001046BF */
    FLASH_DF_BLOCK_283     = 0x001046C0,    /*   64B: 0x001046C0 - 0x001046FF */
    FLASH_DF_BLOCK_284     = 0x00104700,    /*   64B: 0x00104700 - 0x0010473F */
    FLASH_DF_BLOCK_285     = 0x00104740,    /*   64B: 0x00104740 - 0x0010477F */
    FLASH_DF_BLOCK_286     = 0x00104780,    /*   64B: 0x00104780 - 0x001047BF */
    FLASH_DF_BLOCK_287     = 0x001047C0,    /*   64B: 0x001047C0 - 0x001047FF */
    FLASH_DF_BLOCK_288     = 0x00104800,    /*   64B: 0x00104800 - 0x0010483F */
    FLASH_DF_BLOCK_289     = 0x00104840,    /*   64B: 0x00104840 - 0x0010487F */
    FLASH_DF_BLOCK_290     = 0x00104880,    /*   64B: 0x00104880 - 0x001048BF */
    FLASH_DF_BLOCK_291     = 0x001048C0,    /*   64B: 0x001048C0 - 0x001048FF */
    FLASH_DF_BLOCK_292     = 0x00104900,    /*   64B: 0x00104900 - 0x0010493F */
    FLASH_DF_BLOCK_293     = 0x00104940,    /*   64B: 0x00104940 - 0x0010497F */
    FLASH_DF_BLOCK_294     = 0x00104980,    /*   64B: 0x00104980 - 0x001049BF */
    FLASH_DF_BLOCK_295     = 0x001049C0,    /*   64B: 0x001049C0 - 0x001049FF */
    FLASH_DF_BLOCK_296     = 0x00104A00,    /*   64B: 0x00104A00 - 0x00104A3F */
    FLASH_DF_BLOCK_297     = 0x00104A40,    /*   64B: 0x00104A40 - 0x00104A7F */
    FLASH_DF_BLOCK_298     = 0x00104A80,    /*   64B: 0x00104A80 - 0x00104ABF */
    FLASH_DF_BLOCK_299     = 0x00104AC0,    /*   64B: 0x00104AC0 - 0x00104AFF */
    FLASH_DF_BLOCK_300     = 0x00104B00,    /*   64B: 0x00104B00 - 0x00104B3F */
    FLASH_DF_BLOCK_301     = 0x00104B40,    /*   64B: 0x00104B40 - 0x00104B7F */
    FLASH_DF_BLOCK_302     = 0x00104B80,    /*   64B: 0x00104B80 - 0x00104BBF */
    FLASH_DF_BLOCK_303     = 0x00104BC0,    /*   64B: 0x00104BC0 - 0x00104BFF */
    FLASH_DF_BLOCK_304     = 0x00104C00,    /*   64B: 0x00104C00 - 0x00104C3F */
    FLASH_DF_BLOCK_305     = 0x00104C40,    /*   64B: 0x00104C40 - 0x00104C7F */
    FLASH_DF_BLOCK_306     = 0x00104C80,    /*   64B: 0x00104C80 - 0x00104CBF */
    FLASH_DF_BLOCK_307     = 0x00104CC0,    /*   64B: 0x00104CC0 - 0x00104CFF */
    FLASH_DF_BLOCK_308     = 0x00104D00,    /*   64B: 0x00104D00 - 0x00104D3F */
    FLASH_DF_BLOCK_309     = 0x00104D40,    /*   64B: 0x00104D40 - 0x00104D7F */
    FLASH_DF_BLOCK_310     = 0x00104D80,    /*   64B: 0x00104D80 - 0x00104DBF */
    FLASH_DF_BLOCK_311     = 0x00104DC0,    /*   64B: 0x00104DC0 - 0x00104DFF */
    FLASH_DF_BLOCK_312     = 0x00104E00,    /*   64B: 0x00104E00 - 0x00104E3F */
    FLASH_DF_BLOCK_313     = 0x00104E40,    /*   64B: 0x00104E40 - 0x00104E7F */
    FLASH_DF_BLOCK_314     = 0x00104E80,    /*   64B: 0x00104E80 - 0x00104EBF */
    FLASH_DF_BLOCK_315     = 0x00104EC0,    /*   64B: 0x00104EC0 - 0x00104EFF */
    FLASH_DF_BLOCK_316     = 0x00104F00,    /*   64B: 0x00104F00 - 0x00104F3F */
    FLASH_DF_BLOCK_317     = 0x00104F40,    /*   64B: 0x00104F40 - 0x00104F7F */
    FLASH_DF_BLOCK_318     = 0x00104F80,    /*   64B: 0x00104F80 - 0x00104FBF */
    FLASH_DF_BLOCK_319     = 0x00104FC0,    /*   64B: 0x00104FC0 - 0x00104FFF */
    FLASH_DF_BLOCK_320     = 0x00105000,    /*   64B: 0x00105000 - 0x0010503F */
    FLASH_DF_BLOCK_321     = 0x00105040,    /*   64B: 0x00105040 - 0x0010507F */
    FLASH_DF_BLOCK_322     = 0x00105080,    /*   64B: 0x00105080 - 0x001050BF */
    FLASH_DF_BLOCK_323     = 0x001050C0,    /*   64B: 0x001050C0 - 0x001050FF */
    FLASH_DF_BLOCK_324     = 0x00105100,    /*   64B: 0x00105100 - 0x0010513F */
    FLASH_DF_BLOCK_325     = 0x00105140,    /*   64B: 0x00105140 - 0x0010517F */
    FLASH_DF_BLOCK_326     = 0x00105180,    /*   64B: 0x00105180 - 0x001051BF */
    FLASH_DF_BLOCK_327     = 0x001051C0,    /*   64B: 0x001051C0 - 0x001051FF */
    FLASH_DF_BLOCK_328     = 0x00105200,    /*   64B: 0x00105200 - 0x0010523F */
    FLASH_DF_BLOCK_329     = 0x00105240,    /*   64B: 0x00105240 - 0x0010527F */
    FLASH_DF_BLOCK_330     = 0x00105280,    /*   64B: 0x00105280 - 0x001052BF */
    FLASH_DF_BLOCK_331     = 0x001052C0,    /*   64B: 0x001052C0 - 0x001052FF */
    FLASH_DF_BLOCK_332     = 0x00105300,    /*   64B: 0x00105300 - 0x0010533F */
    FLASH_DF_BLOCK_333     = 0x00105340,    /*   64B: 0x00105340 - 0x0010537F */
    FLASH_DF_BLOCK_334     = 0x00105380,    /*   64B: 0x00105380 - 0x001053BF */
    FLASH_DF_BLOCK_335     = 0x001053C0,    /*   64B: 0x001053C0 - 0x001053FF */
    FLASH_DF_BLOCK_336     = 0x00105400,    /*   64B: 0x00105400 - 0x0010543F */
    FLASH_DF_BLOCK_337     = 0x00105440,    /*   64B: 0x00105440 - 0x0010547F */
    FLASH_DF_BLOCK_338     = 0x00105480,    /*   64B: 0x00105480 - 0x001054BF */
    FLASH_DF_BLOCK_339     = 0x001054C0,    /*   64B: 0x001054C0 - 0x001054FF */
    FLASH_DF_BLOCK_340     = 0x00105500,    /*   64B: 0x00105500 - 0x0010553F */
    FLASH_DF_BLOCK_341     = 0x00105540,    /*   64B: 0x00105540 - 0x0010557F */
    FLASH_DF_BLOCK_342     = 0x00105580,    /*   64B: 0x00105580 - 0x001055BF */
    FLASH_DF_BLOCK_343     = 0x001055C0,    /*   64B: 0x001055C0 - 0x001055FF */
    FLASH_DF_BLOCK_344     = 0x00105600,    /*   64B: 0x00105600 - 0x0010563F */
    FLASH_DF_BLOCK_345     = 0x00105640,    /*   64B: 0x00105640 - 0x0010567F */
    FLASH_DF_BLOCK_346     = 0x00105680,    /*   64B: 0x00105680 - 0x001056BF */
    FLASH_DF_BLOCK_347     = 0x001056C0,    /*   64B: 0x001056C0 - 0x001056FF */
    FLASH_DF_BLOCK_348     = 0x00105700,    /*   64B: 0x00105700 - 0x0010573F */
    FLASH_DF_BLOCK_349     = 0x00105740,    /*   64B: 0x00105740 - 0x0010577F */
    FLASH_DF_BLOCK_350     = 0x00105780,    /*   64B: 0x00105780 - 0x001057BF */
    FLASH_DF_BLOCK_351     = 0x001057C0,    /*   64B: 0x001057C0 - 0x001057FF */
    FLASH_DF_BLOCK_352     = 0x00105800,    /*   64B: 0x00105800 - 0x0010583F */
    FLASH_DF_BLOCK_353     = 0x00105840,    /*   64B: 0x00105840 - 0x0010587F */
    FLASH_DF_BLOCK_354     = 0x00105880,    /*   64B: 0x00105880 - 0x001058BF */
    FLASH_DF_BLOCK_355     = 0x001058C0,    /*   64B: 0x001058C0 - 0x001058FF */
    FLASH_DF_BLOCK_356     = 0x00105900,    /*   64B: 0x00105900 - 0x0010593F */
    FLASH_DF_BLOCK_357     = 0x00105940,    /*   64B: 0x00105940 - 0x0010597F */
    FLASH_DF_BLOCK_358     = 0x00105980,    /*   64B: 0x00105980 - 0x001059BF */
    FLASH_DF_BLOCK_359     = 0x001059C0,    /*   64B: 0x001059C0 - 0x001059FF */
    FLASH_DF_BLOCK_360     = 0x00105A00,    /*   64B: 0x00105A00 - 0x00105A3F */
    FLASH_DF_BLOCK_361     = 0x00105A40,    /*   64B: 0x00105A40 - 0x00105A7F */
    FLASH_DF_BLOCK_362     = 0x00105A80,    /*   64B: 0x00105A80 - 0x00105ABF */
    FLASH_DF_BLOCK_363     = 0x00105AC0,    /*   64B: 0x00105AC0 - 0x00105AFF */
    FLASH_DF_BLOCK_364     = 0x00105B00,    /*   64B: 0x00105B00 - 0x00105B3F */
    FLASH_DF_BLOCK_365     = 0x00105B40,    /*   64B: 0x00105B40 - 0x00105B7F */
    FLASH_DF_BLOCK_366     = 0x00105B80,    /*   64B: 0x00105B80 - 0x00105BBF */
    FLASH_DF_BLOCK_367     = 0x00105BC0,    /*   64B: 0x00105BC0 - 0x00105BFF */
    FLASH_DF_BLOCK_368     = 0x00105C00,    /*   64B: 0x00105C00 - 0x00105C3F */
    FLASH_DF_BLOCK_369     = 0x00105C40,    /*   64B: 0x00105C40 - 0x00105C7F */
    FLASH_DF_BLOCK_370     = 0x00105C80,    /*   64B: 0x00105C80 - 0x00105CBF */
    FLASH_DF_BLOCK_371     = 0x00105CC0,    /*   64B: 0x00105CC0 - 0x00105CFF */
    FLASH_DF_BLOCK_372     = 0x00105D00,    /*   64B: 0x00105D00 - 0x00105D3F */
    FLASH_DF_BLOCK_373     = 0x00105D40,    /*   64B: 0x00105D40 - 0x00105D7F */
    FLASH_DF_BLOCK_374     = 0x00105D80,    /*   64B: 0x00105D80 - 0x00105DBF */
    FLASH_DF_BLOCK_375     = 0x00105DC0,    /*   64B: 0x00105DC0 - 0x00105DFF */
    FLASH_DF_BLOCK_376     = 0x00105E00,    /*   64B: 0x00105E00 - 0x00105E3F */
    FLASH_DF_BLOCK_377     = 0x00105E40,    /*   64B: 0x00105E40 - 0x00105E7F */
    FLASH_DF_BLOCK_378     = 0x00105E80,    /*   64B: 0x00105E80 - 0x00105EBF */
    FLASH_DF_BLOCK_379     = 0x00105EC0,    /*   64B: 0x00105EC0 - 0x00105EFF */
    FLASH_DF_BLOCK_380     = 0x00105F00,    /*   64B: 0x00105F00 - 0x00105F3F */
    FLASH_DF_BLOCK_381     = 0x00105F40,    /*   64B: 0x00105F40 - 0x00105F7F */
    FLASH_DF_BLOCK_382     = 0x00105F80,    /*   64B: 0x00105F80 - 0x00105FBF */
    FLASH_DF_BLOCK_383     = 0x00105FC0,    /*   64B: 0x00105FC0 - 0x00105FFF */
    FLASH_DF_BLOCK_384     = 0x00106000,    /*   64B: 0x00106000 - 0x0010603F */
    FLASH_DF_BLOCK_385     = 0x00106040,    /*   64B: 0x00106040 - 0x0010607F */
    FLASH_DF_BLOCK_386     = 0x00106080,    /*   64B: 0x00106080 - 0x001060BF */
    FLASH_DF_BLOCK_387     = 0x001060C0,    /*   64B: 0x001060C0 - 0x001060FF */
    FLASH_DF_BLOCK_388     = 0x00106100,    /*   64B: 0x00106100 - 0x0010613F */
    FLASH_DF_BLOCK_389     = 0x00106140,    /*   64B: 0x00106140 - 0x0010617F */
    FLASH_DF_BLOCK_390     = 0x00106180,    /*   64B: 0x00106180 - 0x001061BF */
    FLASH_DF_BLOCK_391     = 0x001061C0,    /*   64B: 0x001061C0 - 0x001061FF */
    FLASH_DF_BLOCK_392     = 0x00106200,    /*   64B: 0x00106200 - 0x0010623F */
    FLASH_DF_BLOCK_393     = 0x00106240,    /*   64B: 0x00106240 - 0x0010627F */
    FLASH_DF_BLOCK_394     = 0x00106280,    /*   64B: 0x00106280 - 0x001062BF */
    FLASH_DF_BLOCK_395     = 0x001062C0,    /*   64B: 0x001062C0 - 0x001062FF */
    FLASH_DF_BLOCK_396     = 0x00106300,    /*   64B: 0x00106300 - 0x0010633F */
    FLASH_DF_BLOCK_397     = 0x00106340,    /*   64B: 0x00106340 - 0x0010637F */
    FLASH_DF_BLOCK_398     = 0x00106380,    /*   64B: 0x00106380 - 0x001063BF */
    FLASH_DF_BLOCK_399     = 0x001063C0,    /*   64B: 0x001063C0 - 0x001063FF */
    FLASH_DF_BLOCK_400     = 0x00106400,    /*   64B: 0x00106400 - 0x0010643F */
    FLASH_DF_BLOCK_401     = 0x00106440,    /*   64B: 0x00106440 - 0x0010647F */
    FLASH_DF_BLOCK_402     = 0x00106480,    /*   64B: 0x00106480 - 0x001064BF */
    FLASH_DF_BLOCK_403     = 0x001064C0,    /*   64B: 0x001064C0 - 0x001064FF */
    FLASH_DF_BLOCK_404     = 0x00106500,    /*   64B: 0x00106500 - 0x0010653F */
    FLASH_DF_BLOCK_405     = 0x00106540,    /*   64B: 0x00106540 - 0x0010657F */
    FLASH_DF_BLOCK_406     = 0x00106580,    /*   64B: 0x00106580 - 0x001065BF */
    FLASH_DF_BLOCK_407     = 0x001065C0,    /*   64B: 0x001065C0 - 0x001065FF */
    FLASH_DF_BLOCK_408     = 0x00106600,    /*   64B: 0x00106600 - 0x0010663F */
    FLASH_DF_BLOCK_409     = 0x00106640,    /*   64B: 0x00106640 - 0x0010667F */
    FLASH_DF_BLOCK_410     = 0x00106680,    /*   64B: 0x00106680 - 0x001066BF */
    FLASH_DF_BLOCK_411     = 0x001066C0,    /*   64B: 0x001066C0 - 0x001066FF */
    FLASH_DF_BLOCK_412     = 0x00106700,    /*   64B: 0x00106700 - 0x0010673F */
    FLASH_DF_BLOCK_413     = 0x00106740,    /*   64B: 0x00106740 - 0x0010677F */
    FLASH_DF_BLOCK_414     = 0x00106780,    /*   64B: 0x00106780 - 0x001067BF */
    FLASH_DF_BLOCK_415     = 0x001067C0,    /*   64B: 0x001067C0 - 0x001067FF */
    FLASH_DF_BLOCK_416     = 0x00106800,    /*   64B: 0x00106800 - 0x0010683F */
    FLASH_DF_BLOCK_417     = 0x00106840,    /*   64B: 0x00106840 - 0x0010687F */
    FLASH_DF_BLOCK_418     = 0x00106880,    /*   64B: 0x00106880 - 0x001068BF */
    FLASH_DF_BLOCK_419     = 0x001068C0,    /*   64B: 0x001068C0 - 0x001068FF */
    FLASH_DF_BLOCK_420     = 0x00106900,    /*   64B: 0x00106900 - 0x0010693F */
    FLASH_DF_BLOCK_421     = 0x00106940,    /*   64B: 0x00106940 - 0x0010697F */
    FLASH_DF_BLOCK_422     = 0x00106980,    /*   64B: 0x00106980 - 0x001069BF */
    FLASH_DF_BLOCK_423     = 0x001069C0,    /*   64B: 0x001069C0 - 0x001069FF */
    FLASH_DF_BLOCK_424     = 0x00106A00,    /*   64B: 0x00106A00 - 0x00106A3F */
    FLASH_DF_BLOCK_425     = 0x00106A40,    /*   64B: 0x00106A40 - 0x00106A7F */
    FLASH_DF_BLOCK_426     = 0x00106A80,    /*   64B: 0x00106A80 - 0x00106ABF */
    FLASH_DF_BLOCK_427     = 0x00106AC0,    /*   64B: 0x00106AC0 - 0x00106AFF */
    FLASH_DF_BLOCK_428     = 0x00106B00,    /*   64B: 0x00106B00 - 0x00106B3F */
    FLASH_DF_BLOCK_429     = 0x00106B40,    /*   64B: 0x00106B40 - 0x00106B7F */
    FLASH_DF_BLOCK_430     = 0x00106B80,    /*   64B: 0x00106B80 - 0x00106BBF */
    FLASH_DF_BLOCK_431     = 0x00106BC0,    /*   64B: 0x00106BC0 - 0x00106BFF */
    FLASH_DF_BLOCK_432     = 0x00106C00,    /*   64B: 0x00106C00 - 0x00106C3F */
    FLASH_DF_BLOCK_433     = 0x00106C40,    /*   64B: 0x00106C40 - 0x00106C7F */
    FLASH_DF_BLOCK_434     = 0x00106C80,    /*   64B: 0x00106C80 - 0x00106CBF */
    FLASH_DF_BLOCK_435     = 0x00106CC0,    /*   64B: 0x00106CC0 - 0x00106CFF */
    FLASH_DF_BLOCK_436     = 0x00106D00,    /*   64B: 0x00106D00 - 0x00106D3F */
    FLASH_DF_BLOCK_437     = 0x00106D40,    /*   64B: 0x00106D40 - 0x00106D7F */
    FLASH_DF_BLOCK_438     = 0x00106D80,    /*   64B: 0x00106D80 - 0x00106DBF */
    FLASH_DF_BLOCK_439     = 0x00106DC0,    /*   64B: 0x00106DC0 - 0x00106DFF */
    FLASH_DF_BLOCK_440     = 0x00106E00,    /*   64B: 0x00106E00 - 0x00106E3F */
    FLASH_DF_BLOCK_441     = 0x00106E40,    /*   64B: 0x00106E40 - 0x00106E7F */
    FLASH_DF_BLOCK_442     = 0x00106E80,    /*   64B: 0x00106E80 - 0x00106EBF */
    FLASH_DF_BLOCK_443     = 0x00106EC0,    /*   64B: 0x00106EC0 - 0x00106EFF */
    FLASH_DF_BLOCK_444     = 0x00106F00,    /*   64B: 0x00106F00 - 0x00106F3F */
    FLASH_DF_BLOCK_445     = 0x00106F40,    /*   64B: 0x00106F40 - 0x00106F7F */
    FLASH_DF_BLOCK_446     = 0x00106F80,    /*   64B: 0x00106F80 - 0x00106FBF */
    FLASH_DF_BLOCK_447     = 0x00106FC0,    /*   64B: 0x00106FC0 - 0x00106FFF */
    FLASH_DF_BLOCK_448     = 0x00107000,    /*   64B: 0x00107000 - 0x0010703F */
    FLASH_DF_BLOCK_449     = 0x00107040,    /*   64B: 0x00107040 - 0x0010707F */
    FLASH_DF_BLOCK_450     = 0x00107080,    /*   64B: 0x00107080 - 0x001070BF */
    FLASH_DF_BLOCK_451     = 0x001070C0,    /*   64B: 0x001070C0 - 0x001070FF */
    FLASH_DF_BLOCK_452     = 0x00107100,    /*   64B: 0x00107100 - 0x0010713F */
    FLASH_DF_BLOCK_453     = 0x00107140,    /*   64B: 0x00107140 - 0x0010717F */
    FLASH_DF_BLOCK_454     = 0x00107180,    /*   64B: 0x00107180 - 0x001071BF */
    FLASH_DF_BLOCK_455     = 0x001071C0,    /*   64B: 0x001071C0 - 0x001071FF */
    FLASH_DF_BLOCK_456     = 0x00107200,    /*   64B: 0x00107200 - 0x0010723F */
    FLASH_DF_BLOCK_457     = 0x00107240,    /*   64B: 0x00107240 - 0x0010727F */
    FLASH_DF_BLOCK_458     = 0x00107280,    /*   64B: 0x00107280 - 0x001072BF */
    FLASH_DF_BLOCK_459     = 0x001072C0,    /*   64B: 0x001072C0 - 0x001072FF */
    FLASH_DF_BLOCK_460     = 0x00107300,    /*   64B: 0x00107300 - 0x0010733F */
    FLASH_DF_BLOCK_461     = 0x00107340,    /*   64B: 0x00107340 - 0x0010737F */
    FLASH_DF_BLOCK_462     = 0x00107380,    /*   64B: 0x00107380 - 0x001073BF */
    FLASH_DF_BLOCK_463     = 0x001073C0,    /*   64B: 0x001073C0 - 0x001073FF */
    FLASH_DF_BLOCK_464     = 0x00107400,    /*   64B: 0x00107400 - 0x0010743F */
    FLASH_DF_BLOCK_465     = 0x00107440,    /*   64B: 0x00107440 - 0x0010747F */
    FLASH_DF_BLOCK_466     = 0x00107480,    /*   64B: 0x00107480 - 0x001074BF */
    FLASH_DF_BLOCK_467     = 0x001074C0,    /*   64B: 0x001074C0 - 0x001074FF */
    FLASH_DF_BLOCK_468     = 0x00107500,    /*   64B: 0x00107500 - 0x0010753F */
    FLASH_DF_BLOCK_469     = 0x00107540,    /*   64B: 0x00107540 - 0x0010757F */
    FLASH_DF_BLOCK_470     = 0x00107580,    /*   64B: 0x00107580 - 0x001075BF */
    FLASH_DF_BLOCK_471     = 0x001075C0,    /*   64B: 0x001075C0 - 0x001075FF */
    FLASH_DF_BLOCK_472     = 0x00107600,    /*   64B: 0x00107600 - 0x0010763F */
    FLASH_DF_BLOCK_473     = 0x00107640,    /*   64B: 0x00107640 - 0x0010767F */
    FLASH_DF_BLOCK_474     = 0x00107680,    /*   64B: 0x00107680 - 0x001076BF */
    FLASH_DF_BLOCK_475     = 0x001076C0,    /*   64B: 0x001076C0 - 0x001076FF */
    FLASH_DF_BLOCK_476     = 0x00107700,    /*   64B: 0x00107700 - 0x0010773F */
    FLASH_DF_BLOCK_477     = 0x00107740,    /*   64B: 0x00107740 - 0x0010777F */
    FLASH_DF_BLOCK_478     = 0x00107780,    /*   64B: 0x00107780 - 0x001077BF */
    FLASH_DF_BLOCK_479     = 0x001077C0,    /*   64B: 0x001077C0 - 0x001077FF */
    FLASH_DF_BLOCK_480     = 0x00107800,    /*   64B: 0x00107800 - 0x0010783F */
    FLASH_DF_BLOCK_481     = 0x00107840,    /*   64B: 0x00107840 - 0x0010787F */
    FLASH_DF_BLOCK_482     = 0x00107880,    /*   64B: 0x00107880 - 0x001078BF */
    FLASH_DF_BLOCK_483     = 0x001078C0,    /*   64B: 0x001078C0 - 0x001078FF */
    FLASH_DF_BLOCK_484     = 0x00107900,    /*   64B: 0x00107900 - 0x0010793F */
    FLASH_DF_BLOCK_485     = 0x00107940,    /*   64B: 0x00107940 - 0x0010797F */
    FLASH_DF_BLOCK_486     = 0x00107980,    /*   64B: 0x00107980 - 0x001079BF */
    FLASH_DF_BLOCK_487     = 0x001079C0,    /*   64B: 0x001079C0 - 0x001079FF */
    FLASH_DF_BLOCK_488     = 0x00107A00,    /*   64B: 0x00107A00 - 0x00107A3F */
    FLASH_DF_BLOCK_489     = 0x00107A40,    /*   64B: 0x00107A40 - 0x00107A7F */
    FLASH_DF_BLOCK_490     = 0x00107A80,    /*   64B: 0x00107A80 - 0x00107ABF */
    FLASH_DF_BLOCK_491     = 0x00107AC0,    /*   64B: 0x00107AC0 - 0x00107AFF */
    FLASH_DF_BLOCK_492     = 0x00107B00,    /*   64B: 0x00107B00 - 0x00107B3F */
    FLASH_DF_BLOCK_493     = 0x00107B40,    /*   64B: 0x00107B40 - 0x00107B7F */
    FLASH_DF_BLOCK_494     = 0x00107B80,    /*   64B: 0x00107B80 - 0x00107BBF */
    FLASH_DF_BLOCK_495     = 0x00107BC0,    /*   64B: 0x00107BC0 - 0x00107BFF */
    FLASH_DF_BLOCK_496     = 0x00107C00,    /*   64B: 0x00107C00 - 0x00107C3F */
    FLASH_DF_BLOCK_497     = 0x00107C40,    /*   64B: 0x00107C40 - 0x00107C7F */
    FLASH_DF_BLOCK_498     = 0x00107C80,    /*   64B: 0x00107C80 - 0x00107CBF */
    FLASH_DF_BLOCK_499     = 0x00107CC0,    /*   64B: 0x00107CC0 - 0x00107CFF */
    FLASH_DF_BLOCK_500     = 0x00107D00,    /*   64B: 0x00107D00 - 0x00107D3F */
    FLASH_DF_BLOCK_501     = 0x00107D40,    /*   64B: 0x00107D40 - 0x00107D7F */
    FLASH_DF_BLOCK_502     = 0x00107D80,    /*   64B: 0x00107D80 - 0x00107DBF */
    FLASH_DF_BLOCK_503     = 0x00107DC0,    /*   64B: 0x00107DC0 - 0x00107DFF */
    FLASH_DF_BLOCK_504     = 0x00107E00,    /*   64B: 0x00107E00 - 0x00107E3F */
    FLASH_DF_BLOCK_505     = 0x00107E40,    /*   64B: 0x00107E40 - 0x00107E7F */
    FLASH_DF_BLOCK_506     = 0x00107E80,    /*   64B: 0x00107E80 - 0x00107EBF */
    FLASH_DF_BLOCK_507     = 0x00107EC0,    /*   64B: 0x00107EC0 - 0x00107EFF */
    FLASH_DF_BLOCK_508     = 0x00107F00,    /*   64B: 0x00107F00 - 0x00107F3F */
    FLASH_DF_BLOCK_509     = 0x00107F40,    /*   64B: 0x00107F40 - 0x00107F7F */
    FLASH_DF_BLOCK_510     = 0x00107F80,    /*   64B: 0x00107F80 - 0x00107FBF */
    FLASH_DF_BLOCK_511     = 0x00107FC0,    /*   64B: 0x00107FC0 - 0x00107FFF */
    FLASH_DF_BLOCK_INVALID = 0x00108000     /*   Block 511 + 64 bytes */
#endif // MCU_DATA_FLASH_SIZE_BYTES != 0
} flash_block_address_t;


R_BSP_PRAGMA_UNPACK
typedef union
{
    unsigned long LONG;
    R_BSP_ATTRIB_STRUCT_BIT_ORDER_LEFT_6(
        unsigned long BTFLG:1,
        unsigned long :3,
        unsigned long FAWE:12,
        unsigned long FSPR:1,
        unsigned long :3,
        unsigned long FAWS:12
    ) BIT;
} fawreg_t;
R_BSP_PRAGMA_PACKOPTION


/*  According to HW Manual the Max Programming Time for 128 bytes (ROM)
    is 13.2ms.  This is with a FCLK of 4 MHz. The calculation below
    calculates the number of ICLK ticks needed for the timeout delay.
    The 31.2ms number is adjusted linearly depending on the FCLK frequency.
*/
#define WAIT_MAX_ROM_WRITE \
        ((int32_t)(13200 * (60.0/(MCU_CFG_FCLK_HZ/1000000)))*(MCU_CFG_ICLK_HZ/1000000))

/*  According to HW Manual the Max Programming Time for 4 bytes
    (Data Flash) is 1.7ms.  This is with a FCLK of 60MHz. The calculation
    below calculates the number of ICLK ticks needed for the timeout delay.
    The 1.7ms number is adjusted linearly depending on the FCLK frequency.
*/
#define WAIT_MAX_DF_WRITE \
        ((int32_t)(1700 * (60.0/(MCU_CFG_FCLK_HZ/1000000)))*(MCU_CFG_ICLK_HZ/1000000))

/*  According to HW Manual the Max Blank Check time for 4 bytes
    (Data Flash) is 30 usec.  This is with a FCLK of 60MHz. The calculation
    below calculates the number of ICLK ticks needed for the timeout delay.
    The 30 usec number is adjusted linearly depending on the FCLK frequency.
*/
#define WAIT_MAX_BLANK_CHECK \
        ((int32_t)(30 * (60.0/(MCU_CFG_FCLK_HZ/1000000)))*(MCU_CFG_ICLK_HZ/1000000))

/*  According to HW Manual the max timeout value when using the peripheral
    clock notification command is 60us. This is with a FCLK of 50MHz. The
    calculation below calculates the number of ICLK ticks needed for the
    timeout delay. The 60us number is adjusted linearly depending on
    the FCLK frequency.
*/
#define WAIT_MAX_NOTIFY_FCU_CLOCK \
        ((int32_t)(60 * (50.0/(MCU_CFG_FCLK_HZ/1000000)))*(MCU_CFG_ICLK_HZ/1000000))

/*  According to HW Manual the Max Erasure Time for a 32KB block is
    around 480ms.  This is with a FCLK of 4 MHz. The calculation below
    calculates the number of ICLK ticks needed for the timeout delay.
    The 480ms number is adjusted linearly depending on the FCLK frequency.
*/
#define WAIT_MAX_ERASE_CF_32K \
        ((int32_t)(480000 * (60.0/(MCU_CFG_FCLK_HZ/1000000)))*(MCU_CFG_ICLK_HZ/1000000))

/*  According to HW Manual the Max Erasure Time for a 8KB block is
    around 120ms.  This is with a FCLK of 4 MHz. The calculation below
    calculates the number of ICLK ticks needed for the timeout delay.
    The 120ms number is adjusted linearly depending on the FCLK frequency.
*/
#define WAIT_MAX_ERASE_CF_8K \
        ((int32_t)(120000 * (60.0/(MCU_CFG_FCLK_HZ/1000000)))*(MCU_CFG_ICLK_HZ/1000000))

/*  According to HW Manual the Max Erasure Time for a 64 byte Data Flash block is
    around 10ms.  This is with a FCLK of 60MHz. The calculation below
    calculates the number of ICLK ticks needed for the timeout delay.
    The 10ms number is adjusted linearly depending on the FCLK frequency.
*/
#define WAIT_MAX_ERASE_DF \
        ((int32_t)(10000 * (60.0/(MCU_CFG_FCLK_HZ/1000000)))*(MCU_CFG_ICLK_HZ/1000000))

/******************************************************************************
Error checking
******************************************************************************/
// frequency range checking moved to flash_api_open()

#endif/* RX65N_FLASH_PRIVATE_HEADER_FILE */
